/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.IPersonCollectionPage;
import com.microsoft.graph.extensions.IPersonCollectionRequest;
import com.microsoft.graph.extensions.Person;
import com.microsoft.graph.extensions.PersonCollectionPage;
import com.microsoft.graph.extensions.PersonCollectionRequest;
import com.microsoft.graph.extensions.PersonCollectionRequestBuilder;
import com.microsoft.graph.extensions.PersonRequestBuilder;
import com.microsoft.graph.generated.BasePersonCollectionResponse;
import com.microsoft.graph.generated.IBasePersonCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BasePersonCollectionRequest
extends BaseCollectionRequest<BasePersonCollectionResponse, IPersonCollectionPage>
implements IBasePersonCollectionRequest {
    public BasePersonCollectionRequest(String requestUrl, IBaseClient client, List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BasePersonCollectionResponse.class, IPersonCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IPersonCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BasePersonCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IPersonCollectionPage get() throws ClientException {
        BasePersonCollectionResponse response = (BasePersonCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(Person newPerson, ICallback<Person> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new PersonRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newPerson, callback);
    }

    @Override
    public Person post(Person newPerson) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new PersonRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newPerson);
    }

    @Override
    public IPersonCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (PersonCollectionRequest)this;
    }

    @Override
    public IPersonCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (PersonCollectionRequest)this;
    }

    @Override
    public IPersonCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (PersonCollectionRequest)this;
    }

    public IPersonCollectionPage buildFromResponse(BasePersonCollectionResponse response) {
        PersonCollectionRequestBuilder builder = response.nextLink != null ? new PersonCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        PersonCollectionPage page = new PersonCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

