/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.IOnenoteSectionCollectionPage;
import com.microsoft.graph.extensions.IOnenoteSectionCollectionRequest;
import com.microsoft.graph.extensions.OnenoteSection;
import com.microsoft.graph.extensions.OnenoteSectionCollectionPage;
import com.microsoft.graph.extensions.OnenoteSectionCollectionRequest;
import com.microsoft.graph.extensions.OnenoteSectionCollectionRequestBuilder;
import com.microsoft.graph.extensions.OnenoteSectionRequestBuilder;
import com.microsoft.graph.generated.BaseOnenoteSectionCollectionResponse;
import com.microsoft.graph.generated.IBaseOnenoteSectionCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseOnenoteSectionCollectionRequest
extends BaseCollectionRequest<BaseOnenoteSectionCollectionResponse, IOnenoteSectionCollectionPage>
implements IBaseOnenoteSectionCollectionRequest {
    public BaseOnenoteSectionCollectionRequest(String requestUrl, IBaseClient client, List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseOnenoteSectionCollectionResponse.class, IOnenoteSectionCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IOnenoteSectionCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseOnenoteSectionCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IOnenoteSectionCollectionPage get() throws ClientException {
        BaseOnenoteSectionCollectionResponse response = (BaseOnenoteSectionCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(OnenoteSection newOnenoteSection, ICallback<OnenoteSection> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new OnenoteSectionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newOnenoteSection, callback);
    }

    @Override
    public OnenoteSection post(OnenoteSection newOnenoteSection) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new OnenoteSectionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newOnenoteSection);
    }

    @Override
    public IOnenoteSectionCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (OnenoteSectionCollectionRequest)this;
    }

    @Override
    public IOnenoteSectionCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (OnenoteSectionCollectionRequest)this;
    }

    @Override
    public IOnenoteSectionCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (OnenoteSectionCollectionRequest)this;
    }

    public IOnenoteSectionCollectionPage buildFromResponse(BaseOnenoteSectionCollectionResponse response) {
        OnenoteSectionCollectionRequestBuilder builder = response.nextLink != null ? new OnenoteSectionCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        OnenoteSectionCollectionPage page = new OnenoteSectionCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

