/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.IMessageRuleCollectionPage;
import com.microsoft.graph.extensions.IMessageRuleCollectionRequest;
import com.microsoft.graph.extensions.MessageRule;
import com.microsoft.graph.extensions.MessageRuleCollectionPage;
import com.microsoft.graph.extensions.MessageRuleCollectionRequest;
import com.microsoft.graph.extensions.MessageRuleCollectionRequestBuilder;
import com.microsoft.graph.extensions.MessageRuleRequestBuilder;
import com.microsoft.graph.generated.BaseMessageRuleCollectionResponse;
import com.microsoft.graph.generated.IBaseMessageRuleCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseMessageRuleCollectionRequest
extends BaseCollectionRequest<BaseMessageRuleCollectionResponse, IMessageRuleCollectionPage>
implements IBaseMessageRuleCollectionRequest {
    public BaseMessageRuleCollectionRequest(String requestUrl, IBaseClient client, List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseMessageRuleCollectionResponse.class, IMessageRuleCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IMessageRuleCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseMessageRuleCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IMessageRuleCollectionPage get() throws ClientException {
        BaseMessageRuleCollectionResponse response = (BaseMessageRuleCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(MessageRule newMessageRule, ICallback<MessageRule> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new MessageRuleRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newMessageRule, callback);
    }

    @Override
    public MessageRule post(MessageRule newMessageRule) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new MessageRuleRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newMessageRule);
    }

    @Override
    public IMessageRuleCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (MessageRuleCollectionRequest)this;
    }

    @Override
    public IMessageRuleCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (MessageRuleCollectionRequest)this;
    }

    @Override
    public IMessageRuleCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (MessageRuleCollectionRequest)this;
    }

    public IMessageRuleCollectionPage buildFromResponse(BaseMessageRuleCollectionResponse response) {
        MessageRuleCollectionRequestBuilder builder = response.nextLink != null ? new MessageRuleCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        MessageRuleCollectionPage page = new MessageRuleCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

