/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.IListItemVersionCollectionPage;
import com.microsoft.graph.extensions.IListItemVersionCollectionRequest;
import com.microsoft.graph.extensions.ListItemVersion;
import com.microsoft.graph.extensions.ListItemVersionCollectionPage;
import com.microsoft.graph.extensions.ListItemVersionCollectionRequest;
import com.microsoft.graph.extensions.ListItemVersionCollectionRequestBuilder;
import com.microsoft.graph.extensions.ListItemVersionRequestBuilder;
import com.microsoft.graph.generated.BaseListItemVersionCollectionResponse;
import com.microsoft.graph.generated.IBaseListItemVersionCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseListItemVersionCollectionRequest
extends BaseCollectionRequest<BaseListItemVersionCollectionResponse, IListItemVersionCollectionPage>
implements IBaseListItemVersionCollectionRequest {
    public BaseListItemVersionCollectionRequest(String requestUrl, IBaseClient client, List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseListItemVersionCollectionResponse.class, IListItemVersionCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IListItemVersionCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseListItemVersionCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IListItemVersionCollectionPage get() throws ClientException {
        BaseListItemVersionCollectionResponse response = (BaseListItemVersionCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(ListItemVersion newListItemVersion, ICallback<ListItemVersion> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ListItemVersionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newListItemVersion, callback);
    }

    @Override
    public ListItemVersion post(ListItemVersion newListItemVersion) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ListItemVersionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newListItemVersion);
    }

    @Override
    public IListItemVersionCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (ListItemVersionCollectionRequest)this;
    }

    @Override
    public IListItemVersionCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (ListItemVersionCollectionRequest)this;
    }

    @Override
    public IListItemVersionCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (ListItemVersionCollectionRequest)this;
    }

    public IListItemVersionCollectionPage buildFromResponse(BaseListItemVersionCollectionResponse response) {
        ListItemVersionCollectionRequestBuilder builder = response.nextLink != null ? new ListItemVersionCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ListItemVersionCollectionPage page = new ListItemVersionCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

