/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.IListCollectionPage;
import com.microsoft.graph.extensions.IListCollectionRequest;
import com.microsoft.graph.extensions.List;
import com.microsoft.graph.extensions.ListCollectionPage;
import com.microsoft.graph.extensions.ListCollectionRequest;
import com.microsoft.graph.extensions.ListCollectionRequestBuilder;
import com.microsoft.graph.extensions.ListRequestBuilder;
import com.microsoft.graph.generated.BaseListCollectionResponse;
import com.microsoft.graph.generated.IBaseListCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;

public class BaseListCollectionRequest
extends BaseCollectionRequest<BaseListCollectionResponse, IListCollectionPage>
implements IBaseListCollectionRequest {
    public BaseListCollectionRequest(String requestUrl, IBaseClient client, java.util.List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseListCollectionResponse.class, IListCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IListCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseListCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IListCollectionPage get() throws ClientException {
        BaseListCollectionResponse response = (BaseListCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(List newList, ICallback<List> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ListRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newList, callback);
    }

    @Override
    public List post(List newList) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ListRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newList);
    }

    @Override
    public IListCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (ListCollectionRequest)this;
    }

    @Override
    public IListCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (ListCollectionRequest)this;
    }

    @Override
    public IListCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (ListCollectionRequest)this;
    }

    public IListCollectionPage buildFromResponse(BaseListCollectionResponse response) {
        ListCollectionRequestBuilder builder = response.nextLink != null ? new ListCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ListCollectionPage page = new ListCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

