/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.EducationSchool;
import com.microsoft.graph.extensions.EducationSchoolCollectionPage;
import com.microsoft.graph.extensions.EducationSchoolCollectionRequest;
import com.microsoft.graph.extensions.EducationSchoolCollectionRequestBuilder;
import com.microsoft.graph.extensions.EducationSchoolRequestBuilder;
import com.microsoft.graph.extensions.IEducationSchoolCollectionPage;
import com.microsoft.graph.extensions.IEducationSchoolCollectionRequest;
import com.microsoft.graph.generated.BaseEducationSchoolCollectionResponse;
import com.microsoft.graph.generated.IBaseEducationSchoolCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseEducationSchoolCollectionRequest
extends BaseCollectionRequest<BaseEducationSchoolCollectionResponse, IEducationSchoolCollectionPage>
implements IBaseEducationSchoolCollectionRequest {
    public BaseEducationSchoolCollectionRequest(String requestUrl, IBaseClient client, List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseEducationSchoolCollectionResponse.class, IEducationSchoolCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IEducationSchoolCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseEducationSchoolCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IEducationSchoolCollectionPage get() throws ClientException {
        BaseEducationSchoolCollectionResponse response = (BaseEducationSchoolCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(EducationSchool newEducationSchool, ICallback<EducationSchool> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new EducationSchoolRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newEducationSchool, callback);
    }

    @Override
    public EducationSchool post(EducationSchool newEducationSchool) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new EducationSchoolRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newEducationSchool);
    }

    @Override
    public IEducationSchoolCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (EducationSchoolCollectionRequest)this;
    }

    @Override
    public IEducationSchoolCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (EducationSchoolCollectionRequest)this;
    }

    @Override
    public IEducationSchoolCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (EducationSchoolCollectionRequest)this;
    }

    public IEducationSchoolCollectionPage buildFromResponse(BaseEducationSchoolCollectionResponse response) {
        EducationSchoolCollectionRequestBuilder builder = response.nextLink != null ? new EducationSchoolCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        EducationSchoolCollectionPage page = new EducationSchoolCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

