/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.ColumnDefinition;
import com.microsoft.graph.extensions.ColumnDefinitionCollectionPage;
import com.microsoft.graph.extensions.ColumnDefinitionCollectionRequest;
import com.microsoft.graph.extensions.ColumnDefinitionCollectionRequestBuilder;
import com.microsoft.graph.extensions.ColumnDefinitionRequestBuilder;
import com.microsoft.graph.extensions.IColumnDefinitionCollectionPage;
import com.microsoft.graph.extensions.IColumnDefinitionCollectionRequest;
import com.microsoft.graph.generated.BaseColumnDefinitionCollectionResponse;
import com.microsoft.graph.generated.IBaseColumnDefinitionCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseColumnDefinitionCollectionRequest
extends BaseCollectionRequest<BaseColumnDefinitionCollectionResponse, IColumnDefinitionCollectionPage>
implements IBaseColumnDefinitionCollectionRequest {
    public BaseColumnDefinitionCollectionRequest(String requestUrl, IBaseClient client, List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseColumnDefinitionCollectionResponse.class, IColumnDefinitionCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IColumnDefinitionCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseColumnDefinitionCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IColumnDefinitionCollectionPage get() throws ClientException {
        BaseColumnDefinitionCollectionResponse response = (BaseColumnDefinitionCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(ColumnDefinition newColumnDefinition, ICallback<ColumnDefinition> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ColumnDefinitionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newColumnDefinition, callback);
    }

    @Override
    public ColumnDefinition post(ColumnDefinition newColumnDefinition) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ColumnDefinitionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newColumnDefinition);
    }

    @Override
    public IColumnDefinitionCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (ColumnDefinitionCollectionRequest)this;
    }

    @Override
    public IColumnDefinitionCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (ColumnDefinitionCollectionRequest)this;
    }

    @Override
    public IColumnDefinitionCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (ColumnDefinitionCollectionRequest)this;
    }

    public IColumnDefinitionCollectionPage buildFromResponse(BaseColumnDefinitionCollectionResponse response) {
        ColumnDefinitionCollectionRequestBuilder builder = response.nextLink != null ? new ColumnDefinitionCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ColumnDefinitionCollectionPage page = new ColumnDefinitionCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

