/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.BaseItem;
import com.microsoft.graph.extensions.BaseItemCollectionPage;
import com.microsoft.graph.extensions.BaseItemCollectionRequest;
import com.microsoft.graph.extensions.BaseItemCollectionRequestBuilder;
import com.microsoft.graph.extensions.BaseItemRequestBuilder;
import com.microsoft.graph.extensions.IBaseItemCollectionPage;
import com.microsoft.graph.extensions.IBaseItemCollectionRequest;
import com.microsoft.graph.generated.BaseBaseItemCollectionResponse;
import com.microsoft.graph.generated.IBaseBaseItemCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseBaseItemCollectionRequest
extends BaseCollectionRequest<BaseBaseItemCollectionResponse, IBaseItemCollectionPage>
implements IBaseBaseItemCollectionRequest {
    public BaseBaseItemCollectionRequest(String requestUrl, IBaseClient client, List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseBaseItemCollectionResponse.class, IBaseItemCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IBaseItemCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseBaseItemCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IBaseItemCollectionPage get() throws ClientException {
        BaseBaseItemCollectionResponse response = (BaseBaseItemCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(BaseItem newBaseItem, ICallback<BaseItem> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new BaseItemRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newBaseItem, callback);
    }

    @Override
    public BaseItem post(BaseItem newBaseItem) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new BaseItemRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newBaseItem);
    }

    @Override
    public IBaseItemCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (BaseItemCollectionRequest)this;
    }

    @Override
    public IBaseItemCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (BaseItemCollectionRequest)this;
    }

    @Override
    public IBaseItemCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (BaseItemCollectionRequest)this;
    }

    public IBaseItemCollectionPage buildFromResponse(BaseBaseItemCollectionResponse response) {
        BaseItemCollectionRequestBuilder builder = response.nextLink != null ? new BaseItemCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        BaseItemCollectionPage page = new BaseItemCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

