/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.extensions;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.GraphErrorCodes;
import com.microsoft.graph.extensions.UploadSession;
import com.microsoft.graph.http.GraphServiceException;

public class ChunkedUploadResult<UploadType> {
    private final UploadType mUploadedItem;
    private final UploadSession mSession;
    private final ClientException mError;

    public ChunkedUploadResult(UploadType uploaded) {
        this.mUploadedItem = uploaded;
        this.mSession = null;
        this.mError = null;
    }

    public ChunkedUploadResult(UploadSession session) {
        this.mSession = session;
        this.mUploadedItem = null;
        this.mError = null;
    }

    public ChunkedUploadResult(ClientException error) {
        this.mError = error;
        this.mUploadedItem = null;
        this.mSession = null;
    }

    public ChunkedUploadResult(GraphServiceException exception) {
        this(new ClientException(exception.getMessage(true), exception, GraphErrorCodes.UploadSessionFailed));
    }

    public boolean chunkCompleted() {
        return this.mUploadedItem != null || this.mSession != null;
    }

    public boolean uploadCompleted() {
        return this.mUploadedItem != null;
    }

    public boolean hasError() {
        return this.mError != null;
    }

    public UploadType getItem() {
        return this.mUploadedItem;
    }

    public UploadSession getSession() {
        return this.mSession;
    }

    public ClientException getError() {
        return this.mError;
    }
}

