/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.concurrency;

import android.os.Handler;
import android.os.Looper;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;

public class SynchronousExecutor
implements Executor {
    private AtomicInteger mActiveCount = new AtomicInteger(0);

    @Override
    public void execute(final Runnable runnable) {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                SynchronousExecutor.this.mActiveCount.incrementAndGet();
                runnable.run();
                SynchronousExecutor.this.mActiveCount.decrementAndGet();
            }
        });
    }

    public int getActiveCount() {
        return this.mActiveCount.get();
    }
}

