/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.concurrency;

import com.microsoft.graph.concurrency.ChunkedUploadResponseHandler;
import com.microsoft.graph.concurrency.IProgressCallback;
import com.microsoft.graph.extensions.ChunkedUploadRequest;
import com.microsoft.graph.extensions.ChunkedUploadResult;
import com.microsoft.graph.extensions.IGraphServiceClient;
import com.microsoft.graph.extensions.UploadSession;
import com.microsoft.graph.options.Option;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidParameterException;
import java.util.List;

public class ChunkedUploadProvider<UploadType> {
    private static final int DEFAULT_CHUNK_SIZE = 0x500000;
    private static final int REQUIRED_CHUNK_SIZE_INCREMENT = 327680;
    private static final int MAXIMUM_CHUNK_SIZE = 0x3C00000;
    private static final int MAXIMUM_RETRY_TIMES = 3;
    private final IGraphServiceClient mClient;
    private final InputStream mInputStream;
    private final String mUploadUrl;
    private final int mStreamSize;
    private final ChunkedUploadResponseHandler<UploadType> mResponseHandler;
    private int mReadSoFar;

    public ChunkedUploadProvider(UploadSession uploadSession, IGraphServiceClient client, InputStream inputStream, int streamSize, Class<UploadType> uploadTypeClass) {
        if (uploadSession == null) {
            throw new InvalidParameterException("Upload session is null.");
        }
        if (client == null) {
            throw new InvalidParameterException("OneDrive client is null.");
        }
        if (inputStream == null) {
            throw new InvalidParameterException("Input stream is null.");
        }
        if (streamSize <= 0) {
            throw new InvalidParameterException("Stream size should larger than 0.");
        }
        this.mClient = client;
        this.mReadSoFar = 0;
        this.mInputStream = inputStream;
        this.mStreamSize = streamSize;
        this.mUploadUrl = uploadSession.uploadUrl;
        this.mResponseHandler = new ChunkedUploadResponseHandler<UploadType>(uploadTypeClass);
    }

    public void upload(List<Option> options, IProgressCallback<UploadType> callback, int ... configs) throws IOException {
        int read;
        int chunkSize = 0x500000;
        if (configs.length > 0) {
            chunkSize = configs[0];
        }
        int maxRetry = 3;
        if (configs.length > 1) {
            maxRetry = configs[1];
        }
        if (chunkSize % 327680 != 0) {
            throw new IllegalArgumentException("Chunk size must be a multiple of 320 KiB");
        }
        if (chunkSize > 0x3C00000) {
            throw new IllegalArgumentException("Please set chunk size smaller than 60 MiB");
        }
        byte[] buffer = new byte[chunkSize];
        while (this.mReadSoFar < this.mStreamSize && (read = this.mInputStream.read(buffer)) != -1) {
            ChunkedUploadRequest request = new ChunkedUploadRequest(this.mUploadUrl, this.mClient, options, buffer, read, maxRetry, this.mReadSoFar, this.mStreamSize);
            ChunkedUploadResult result = request.upload(this.mResponseHandler);
            if (result.uploadCompleted()) {
                callback.progress(this.mStreamSize, this.mStreamSize);
                callback.success(result.getItem());
                break;
            }
            if (result.chunkCompleted()) {
                callback.progress(this.mReadSoFar, this.mStreamSize);
            } else if (result.hasError()) {
                callback.failure(result.getError());
                break;
            }
            this.mReadSoFar += read;
        }
    }
}

