// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Workbook Pivot Table Request.
 */
public interface IBaseWorkbookPivotTableRequest extends IHttpRequest {

    /**
     * Gets the WorkbookPivotTable from the service
     * @param callback The callback to be called after success or failure.
     */
    void get(final ICallback<WorkbookPivotTable> callback);

    /**
     * Gets the WorkbookPivotTable from the service
     * @return The WorkbookPivotTable from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    WorkbookPivotTable get() throws ClientException;

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    void delete(final ICallback<Void> callback);

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this WorkbookPivotTable with a source
     * @param sourceWorkbookPivotTable The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    void patch(final WorkbookPivotTable sourceWorkbookPivotTable, final ICallback<WorkbookPivotTable> callback);

    /**
     * Patches this WorkbookPivotTable with a source
     * @param sourceWorkbookPivotTable The source object with updates
     * @return The updated WorkbookPivotTable
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    WorkbookPivotTable patch(final WorkbookPivotTable sourceWorkbookPivotTable) throws ClientException;

    /**
     * Posts a WorkbookPivotTable with a new object
     * @param newWorkbookPivotTable The new object to create
     * @param callback The callback to be called after success or failure.
     */
    void post(final WorkbookPivotTable newWorkbookPivotTable, final ICallback<WorkbookPivotTable> callback);

    /**
     * Posts a WorkbookPivotTable with a new object
     * @param newWorkbookPivotTable The new object to create
     * @return The created WorkbookPivotTable
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    WorkbookPivotTable post(final WorkbookPivotTable newWorkbookPivotTable) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBaseWorkbookPivotTableRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBaseWorkbookPivotTableRequest expand(final String value);

}

