// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Vpp Token Request.
 */
public interface IBaseVppTokenRequest extends IHttpRequest {

    /**
     * Gets the VppToken from the service
     * @param callback The callback to be called after success or failure.
     */
    void get(final ICallback<VppToken> callback);

    /**
     * Gets the VppToken from the service
     * @return The VppToken from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    VppToken get() throws ClientException;

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    void delete(final ICallback<Void> callback);

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this VppToken with a source
     * @param sourceVppToken The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    void patch(final VppToken sourceVppToken, final ICallback<VppToken> callback);

    /**
     * Patches this VppToken with a source
     * @param sourceVppToken The source object with updates
     * @return The updated VppToken
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    VppToken patch(final VppToken sourceVppToken) throws ClientException;

    /**
     * Posts a VppToken with a new object
     * @param newVppToken The new object to create
     * @param callback The callback to be called after success or failure.
     */
    void post(final VppToken newVppToken, final ICallback<VppToken> callback);

    /**
     * Posts a VppToken with a new object
     * @param newVppToken The new object to create
     * @return The created VppToken
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    VppToken post(final VppToken newVppToken) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBaseVppTokenRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBaseVppTokenRequest expand(final String value);

}

