// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base User Request Builder.
 */
public interface IBaseUserRequestBuilder extends IRequestBuilder {
    /**
     * Creates the request
     */
    IUserRequest buildRequest();

    /**
     * Creates the request with specific options instead of the existing options
     */
    IUserRequest buildRequest(final java.util.List<Option> requestOptions);

    IDirectoryObjectCollectionWithReferencesRequestBuilder getOwnedDevices();

    IDirectoryObjectWithReferenceRequestBuilder getOwnedDevices(final String id);

    IDirectoryObjectCollectionWithReferencesRequestBuilder getRegisteredDevices();

    IDirectoryObjectWithReferenceRequestBuilder getRegisteredDevices(final String id);

    /**
     * Gets the request builder for DirectoryObject.
     */
    IDirectoryObjectWithReferenceRequestBuilder getManager();

    IDirectoryObjectCollectionWithReferencesRequestBuilder getDirectReports();

    IDirectoryObjectWithReferenceRequestBuilder getDirectReports(final String id);

    IDirectoryObjectCollectionWithReferencesRequestBuilder getMemberOf();

    IDirectoryObjectWithReferenceRequestBuilder getMemberOf(final String id);

    IDirectoryObjectCollectionWithReferencesRequestBuilder getCreatedObjects();

    IDirectoryObjectWithReferenceRequestBuilder getCreatedObjects(final String id);

    IDirectoryObjectCollectionWithReferencesRequestBuilder getOwnedObjects();

    IDirectoryObjectWithReferenceRequestBuilder getOwnedObjects(final String id);

    ILicenseDetailsCollectionRequestBuilder getLicenseDetails();

    ILicenseDetailsRequestBuilder getLicenseDetails(final String id);

    IExtensionCollectionRequestBuilder getExtensions();

    IExtensionRequestBuilder getExtensions(final String id);

    /**
     * Gets the request builder for OutlookUser.
     */
    IOutlookUserRequestBuilder getOutlook();

    IMessageCollectionRequestBuilder getMessages();

    IMessageRequestBuilder getMessages(final String id);

    IMailFolderCollectionRequestBuilder getMailFolders();

    IMailFolderRequestBuilder getMailFolders(final String id);

    /**
     * Gets the request builder for Calendar.
     */
    ICalendarRequestBuilder getCalendar();

    ICalendarCollectionRequestBuilder getCalendars();

    ICalendarRequestBuilder getCalendars(final String id);

    ICalendarGroupCollectionRequestBuilder getCalendarGroups();

    ICalendarGroupRequestBuilder getCalendarGroups(final String id);

    IEventCollectionRequestBuilder getCalendarView();

    IEventRequestBuilder getCalendarView(final String id);

    IEventCollectionRequestBuilder getEvents();

    IEventRequestBuilder getEvents(final String id);

    IPersonCollectionRequestBuilder getPeople();

    IPersonRequestBuilder getPeople(final String id);

    IContactCollectionRequestBuilder getContacts();

    IContactRequestBuilder getContacts(final String id);

    IContactFolderCollectionRequestBuilder getContactFolders();

    IContactFolderRequestBuilder getContactFolders(final String id);

    /**
     * Gets the request builder for InferenceClassification.
     */
    IInferenceClassificationRequestBuilder getInferenceClassification();

    /**
     * Gets the request builder for ProfilePhoto.
     */
    IProfilePhotoRequestBuilder getPhoto();

    IProfilePhotoCollectionRequestBuilder getPhotos();

    IProfilePhotoRequestBuilder getPhotos(final String id);

    /**
     * Gets the request builder for Drive.
     */
    IDriveRequestBuilder getDrive();

    IDriveCollectionRequestBuilder getDrives();

    IDriveRequestBuilder getDrives(final String id);

    /**
     * Gets the request builder for PlannerUser.
     */
    IPlannerUserRequestBuilder getPlanner();

    /**
     * Gets the request builder for Onenote.
     */
    IOnenoteRequestBuilder getOnenote();

    IUserActivityCollectionRequestBuilder getActivities();

    IUserActivityRequestBuilder getActivities(final String id);
    IUserAssignLicenseRequestBuilder getAssignLicense(final java.util.List<AssignedLicense> addLicenses, final java.util.List<java.util.UUID> removeLicenses);
    IUserChangePasswordRequestBuilder getChangePassword(final String currentPassword, final String newPassword);
    IUserSendMailRequestBuilder getSendMail(final Message message, final Boolean saveToSentItems);
    IUserFindMeetingTimesRequestBuilder getFindMeetingTimes(final java.util.List<AttendeeBase> attendees, final LocationConstraint locationConstraint, final TimeConstraint timeConstraint, final javax.xml.datatype.Duration meetingDuration, final Integer maxCandidates, final Boolean isOrganizerOptional, final Boolean returnSuggestionReasons, final Double minimumAttendeePercentage);

    IUserReminderViewCollectionRequestBuilder getReminderView(final String startDateTime, final String endDateTime);

}
