// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base User Activity Request.
 */
public interface IBaseUserActivityRequest extends IHttpRequest {

    /**
     * Gets the UserActivity from the service
     * @param callback The callback to be called after success or failure.
     */
    void get(final ICallback<UserActivity> callback);

    /**
     * Gets the UserActivity from the service
     * @return The UserActivity from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    UserActivity get() throws ClientException;

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    void delete(final ICallback<Void> callback);

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this UserActivity with a source
     * @param sourceUserActivity The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    void patch(final UserActivity sourceUserActivity, final ICallback<UserActivity> callback);

    /**
     * Patches this UserActivity with a source
     * @param sourceUserActivity The source object with updates
     * @return The updated UserActivity
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    UserActivity patch(final UserActivity sourceUserActivity) throws ClientException;

    /**
     * Posts a UserActivity with a new object
     * @param newUserActivity The new object to create
     * @param callback The callback to be called after success or failure.
     */
    void post(final UserActivity newUserActivity, final ICallback<UserActivity> callback);

    /**
     * Posts a UserActivity with a new object
     * @param newUserActivity The new object to create
     * @return The created UserActivity
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    UserActivity post(final UserActivity newUserActivity) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBaseUserActivityRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBaseUserActivityRequest expand(final String value);

}

