// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Planner Progress Task Board Task Format Request.
 */
public interface IBasePlannerProgressTaskBoardTaskFormatRequest extends IHttpRequest {

    /**
     * Gets the PlannerProgressTaskBoardTaskFormat from the service
     * @param callback The callback to be called after success or failure.
     */
    void get(final ICallback<PlannerProgressTaskBoardTaskFormat> callback);

    /**
     * Gets the PlannerProgressTaskBoardTaskFormat from the service
     * @return The PlannerProgressTaskBoardTaskFormat from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    PlannerProgressTaskBoardTaskFormat get() throws ClientException;

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    void delete(final ICallback<Void> callback);

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this PlannerProgressTaskBoardTaskFormat with a source
     * @param sourcePlannerProgressTaskBoardTaskFormat The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    void patch(final PlannerProgressTaskBoardTaskFormat sourcePlannerProgressTaskBoardTaskFormat, final ICallback<PlannerProgressTaskBoardTaskFormat> callback);

    /**
     * Patches this PlannerProgressTaskBoardTaskFormat with a source
     * @param sourcePlannerProgressTaskBoardTaskFormat The source object with updates
     * @return The updated PlannerProgressTaskBoardTaskFormat
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    PlannerProgressTaskBoardTaskFormat patch(final PlannerProgressTaskBoardTaskFormat sourcePlannerProgressTaskBoardTaskFormat) throws ClientException;

    /**
     * Posts a PlannerProgressTaskBoardTaskFormat with a new object
     * @param newPlannerProgressTaskBoardTaskFormat The new object to create
     * @param callback The callback to be called after success or failure.
     */
    void post(final PlannerProgressTaskBoardTaskFormat newPlannerProgressTaskBoardTaskFormat, final ICallback<PlannerProgressTaskBoardTaskFormat> callback);

    /**
     * Posts a PlannerProgressTaskBoardTaskFormat with a new object
     * @param newPlannerProgressTaskBoardTaskFormat The new object to create
     * @return The created PlannerProgressTaskBoardTaskFormat
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    PlannerProgressTaskBoardTaskFormat post(final PlannerProgressTaskBoardTaskFormat newPlannerProgressTaskBoardTaskFormat) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBasePlannerProgressTaskBoardTaskFormatRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBasePlannerProgressTaskBoardTaskFormatRequest expand(final String value);

}

