// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Outlook Category Request.
 */
public interface IBaseOutlookCategoryRequest extends IHttpRequest {

    /**
     * Gets the OutlookCategory from the service
     * @param callback The callback to be called after success or failure.
     */
    void get(final ICallback<OutlookCategory> callback);

    /**
     * Gets the OutlookCategory from the service
     * @return The OutlookCategory from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    OutlookCategory get() throws ClientException;

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    void delete(final ICallback<Void> callback);

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this OutlookCategory with a source
     * @param sourceOutlookCategory The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    void patch(final OutlookCategory sourceOutlookCategory, final ICallback<OutlookCategory> callback);

    /**
     * Patches this OutlookCategory with a source
     * @param sourceOutlookCategory The source object with updates
     * @return The updated OutlookCategory
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    OutlookCategory patch(final OutlookCategory sourceOutlookCategory) throws ClientException;

    /**
     * Posts a OutlookCategory with a new object
     * @param newOutlookCategory The new object to create
     * @param callback The callback to be called after success or failure.
     */
    void post(final OutlookCategory newOutlookCategory, final ICallback<OutlookCategory> callback);

    /**
     * Posts a OutlookCategory with a new object
     * @param newOutlookCategory The new object to create
     * @return The created OutlookCategory
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    OutlookCategory post(final OutlookCategory newOutlookCategory) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBaseOutlookCategoryRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBaseOutlookCategoryRequest expand(final String value);

}

