// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Education School Request.
 */
public interface IBaseEducationSchoolRequest extends IHttpRequest {

    /**
     * Gets the EducationSchool from the service
     * @param callback The callback to be called after success or failure.
     */
    void get(final ICallback<EducationSchool> callback);

    /**
     * Gets the EducationSchool from the service
     * @return The EducationSchool from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    EducationSchool get() throws ClientException;

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    void delete(final ICallback<Void> callback);

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this EducationSchool with a source
     * @param sourceEducationSchool The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    void patch(final EducationSchool sourceEducationSchool, final ICallback<EducationSchool> callback);

    /**
     * Patches this EducationSchool with a source
     * @param sourceEducationSchool The source object with updates
     * @return The updated EducationSchool
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    EducationSchool patch(final EducationSchool sourceEducationSchool) throws ClientException;

    /**
     * Posts a EducationSchool with a new object
     * @param newEducationSchool The new object to create
     * @param callback The callback to be called after success or failure.
     */
    void post(final EducationSchool newEducationSchool, final ICallback<EducationSchool> callback);

    /**
     * Posts a EducationSchool with a new object
     * @param newEducationSchool The new object to create
     * @return The created EducationSchool
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    EducationSchool post(final EducationSchool newEducationSchool) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBaseEducationSchoolRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBaseEducationSchoolRequest expand(final String value);

}

