// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Education School Reference Request.
 */
public interface IBaseEducationSchoolReferenceRequest extends IHttpRequest {

    void delete(final ICallback<EducationSchool> callback);

    EducationSchool delete() throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBaseEducationSchoolReferenceRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBaseEducationSchoolReferenceRequest expand(final String value);

    /**
     * Puts the EducationSchool
     *
     * @param srcEducationSchool The EducationSchool to PUT
     * @param callback The callback to be called after success or failure
     */
    void put(EducationSchool srcEducationSchool, final ICallback<EducationSchool> callback);

    /**
     * Puts the EducationSchool
     *
     * @param srcEducationSchool The EducationSchool to PUT
     * @return The EducationSchool
     * @throws ClientException An exception occurs if there was an error while the request was sent
     */
    EducationSchool put(EducationSchool srcEducationSchool) throws ClientException;
}
