// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Education Class Request.
 */
public interface IBaseEducationClassRequest extends IHttpRequest {

    /**
     * Gets the EducationClass from the service
     * @param callback The callback to be called after success or failure.
     */
    void get(final ICallback<EducationClass> callback);

    /**
     * Gets the EducationClass from the service
     * @return The EducationClass from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    EducationClass get() throws ClientException;

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    void delete(final ICallback<Void> callback);

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this EducationClass with a source
     * @param sourceEducationClass The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    void patch(final EducationClass sourceEducationClass, final ICallback<EducationClass> callback);

    /**
     * Patches this EducationClass with a source
     * @param sourceEducationClass The source object with updates
     * @return The updated EducationClass
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    EducationClass patch(final EducationClass sourceEducationClass) throws ClientException;

    /**
     * Posts a EducationClass with a new object
     * @param newEducationClass The new object to create
     * @param callback The callback to be called after success or failure.
     */
    void post(final EducationClass newEducationClass, final ICallback<EducationClass> callback);

    /**
     * Posts a EducationClass with a new object
     * @param newEducationClass The new object to create
     * @return The created EducationClass
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    EducationClass post(final EducationClass newEducationClass) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBaseEducationClassRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBaseEducationClassRequest expand(final String value);

}

