// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Domain Request.
 */
public interface IBaseDomainRequest extends IHttpRequest {

    /**
     * Gets the Domain from the service
     * @param callback The callback to be called after success or failure.
     */
    void get(final ICallback<Domain> callback);

    /**
     * Gets the Domain from the service
     * @return The Domain from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    Domain get() throws ClientException;

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    void delete(final ICallback<Void> callback);

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this Domain with a source
     * @param sourceDomain The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    void patch(final Domain sourceDomain, final ICallback<Domain> callback);

    /**
     * Patches this Domain with a source
     * @param sourceDomain The source object with updates
     * @return The updated Domain
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    Domain patch(final Domain sourceDomain) throws ClientException;

    /**
     * Posts a Domain with a new object
     * @param newDomain The new object to create
     * @param callback The callback to be called after success or failure.
     */
    void post(final Domain newDomain, final ICallback<Domain> callback);

    /**
     * Posts a Domain with a new object
     * @param newDomain The new object to create
     * @return The created Domain
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    Domain post(final Domain newDomain) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBaseDomainRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBaseDomainRequest expand(final String value);

}

