// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Domain Dns Record Request.
 */
public interface IBaseDomainDnsRecordRequest extends IHttpRequest {

    /**
     * Gets the DomainDnsRecord from the service
     * @param callback The callback to be called after success or failure.
     */
    void getDomainDnsRecord(final ICallback<DomainDnsRecord> callback);

    /**
     * Gets the DomainDnsRecord from the service
     * @return The DomainDnsRecord from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    DomainDnsRecord getDomainDnsRecord() throws ClientException;

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    void delete(final ICallback<Void> callback);

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this DomainDnsRecord with a source
     * @param sourceDomainDnsRecord The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    void patch(final DomainDnsRecord sourceDomainDnsRecord, final ICallback<DomainDnsRecord> callback);

    /**
     * Patches this DomainDnsRecord with a source
     * @param sourceDomainDnsRecord The source object with updates
     * @return The updated DomainDnsRecord
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    DomainDnsRecord patch(final DomainDnsRecord sourceDomainDnsRecord) throws ClientException;

    /**
     * Posts a DomainDnsRecord with a new object
     * @param newDomainDnsRecord The new object to create
     * @param callback The callback to be called after success or failure.
     */
    void post(final DomainDnsRecord newDomainDnsRecord, final ICallback<DomainDnsRecord> callback);

    /**
     * Posts a DomainDnsRecord with a new object
     * @param newDomainDnsRecord The new object to create
     * @return The created DomainDnsRecord
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    DomainDnsRecord post(final DomainDnsRecord newDomainDnsRecord) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBaseDomainDnsRecordRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBaseDomainDnsRecordRequest expand(final String value);

}

