// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Calendar Request.
 */
public interface IBaseCalendarRequest extends IHttpRequest {

    /**
     * Gets the Calendar from the service
     * @param callback The callback to be called after success or failure.
     */
    void get(final ICallback<Calendar> callback);

    /**
     * Gets the Calendar from the service
     * @return The Calendar from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    Calendar get() throws ClientException;

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    void delete(final ICallback<Void> callback);

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this Calendar with a source
     * @param sourceCalendar The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    void patch(final Calendar sourceCalendar, final ICallback<Calendar> callback);

    /**
     * Patches this Calendar with a source
     * @param sourceCalendar The source object with updates
     * @return The updated Calendar
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    Calendar patch(final Calendar sourceCalendar) throws ClientException;

    /**
     * Posts a Calendar with a new object
     * @param newCalendar The new object to create
     * @param callback The callback to be called after success or failure.
     */
    void post(final Calendar newCalendar, final ICallback<Calendar> callback);

    /**
     * Posts a Calendar with a new object
     * @param newCalendar The new object to create
     * @return The created Calendar
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    Calendar post(final Calendar newCalendar) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBaseCalendarRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBaseCalendarRequest expand(final String value);

}

