// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Base Item Version Request.
 */
public interface IBaseBaseItemVersionRequest extends IHttpRequest {

    /**
     * Gets the BaseItemVersion from the service
     * @param callback The callback to be called after success or failure.
     */
    void getBaseItemVersion(final ICallback<BaseItemVersion> callback);

    /**
     * Gets the BaseItemVersion from the service
     * @return The BaseItemVersion from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    BaseItemVersion getBaseItemVersion() throws ClientException;

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    void delete(final ICallback<Void> callback);

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this BaseItemVersion with a source
     * @param sourceBaseItemVersion The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    void patch(final BaseItemVersion sourceBaseItemVersion, final ICallback<BaseItemVersion> callback);

    /**
     * Patches this BaseItemVersion with a source
     * @param sourceBaseItemVersion The source object with updates
     * @return The updated BaseItemVersion
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    BaseItemVersion patch(final BaseItemVersion sourceBaseItemVersion) throws ClientException;

    /**
     * Posts a BaseItemVersion with a new object
     * @param newBaseItemVersion The new object to create
     * @param callback The callback to be called after success or failure.
     */
    void post(final BaseItemVersion newBaseItemVersion, final ICallback<BaseItemVersion> callback);

    /**
     * Posts a BaseItemVersion with a new object
     * @param newBaseItemVersion The new object to create
     * @return The created BaseItemVersion
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    BaseItemVersion post(final BaseItemVersion newBaseItemVersion) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBaseBaseItemVersionRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBaseBaseItemVersionRequest expand(final String value);

}

