// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Range View Request.
 */
public class BaseWorkbookRangeViewRequest extends BaseRequest implements IBaseWorkbookRangeViewRequest {

    /**
     * The request for the WorkbookRangeView
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     * @param responseClass The class of the reponse
     */
    public BaseWorkbookRangeViewRequest(final String requestUrl,
            final IBaseClient client,
            final java.util.List<Option> requestOptions,
            final Class responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * Gets the WorkbookRangeView from the service
     * @param callback The callback to be called after success or failure.
     */
    public void get(final ICallback<WorkbookRangeView> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the WorkbookRangeView from the service
     * @return The WorkbookRangeView from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public WorkbookRangeView get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    public void delete(final ICallback<Void> callback) {{
        send(HttpMethod.DELETE, callback, null);
    }}

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {{
        send(HttpMethod.DELETE, null);
    }}

    /**
     * Patches this WorkbookRangeView with a source
     * @param sourceWorkbookRangeView The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    public void patch(final WorkbookRangeView sourceWorkbookRangeView, final ICallback<WorkbookRangeView> callback) {
        send(HttpMethod.PATCH, callback, sourceWorkbookRangeView);
    }

    /**
     * Patches this WorkbookRangeView with a source
     * @param sourceWorkbookRangeView The source object with updates
     * @return The updated WorkbookRangeView
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public WorkbookRangeView patch(final WorkbookRangeView sourceWorkbookRangeView) throws ClientException {
        return send(HttpMethod.PATCH, sourceWorkbookRangeView);
    }

    /**
     * Creates a WorkbookRangeView with a new object
     * @param newWorkbookRangeView The new object to create
     * @param callback The callback to be called after success or failure.
     */
    public void post(final WorkbookRangeView newWorkbookRangeView, final ICallback<WorkbookRangeView> callback) {
        send(HttpMethod.POST, callback, newWorkbookRangeView);
    }

    /**
     * Creates a WorkbookRangeView with a new object
     * @param newWorkbookRangeView The new object to create
     * @return The created WorkbookRangeView
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public WorkbookRangeView post(final WorkbookRangeView newWorkbookRangeView) throws ClientException {
        return send(HttpMethod.POST, newWorkbookRangeView);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
     public IWorkbookRangeViewRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (WorkbookRangeViewRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
     public IWorkbookRangeViewRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (WorkbookRangeViewRequest)this;
     }

}

