// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Functions Nominal Request Builder.
 */
public class BaseWorkbookFunctionsNominalRequestBuilder extends BaseActionRequestBuilder {

    /**
     * The request builder for this WorkbookFunctionsNominal
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseWorkbookFunctionsNominalRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<Option> requestOptions, final com.google.gson.JsonElement effectRate, final com.google.gson.JsonElement npery) {
        super(requestUrl, client, requestOptions);
        mBodyParams.put("effectRate", effectRate);
        mBodyParams.put("npery", npery);
    }

    /**
     * Creates the IWorkbookFunctionsNominalRequest
     *
     * @return The IWorkbookFunctionsNominalRequest instance
     */
    public IWorkbookFunctionsNominalRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IWorkbookFunctionsNominalRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return The IWorkbookFunctionsNominalRequest instance
     */
    public IWorkbookFunctionsNominalRequest buildRequest(final java.util.List<Option> requestOptions) {
        WorkbookFunctionsNominalRequest request = new WorkbookFunctionsNominalRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("effectRate")) {
            request.mBody.effectRate = getParameter("effectRate");
        }

        if (hasParameter("npery")) {
            request.mBody.npery = getParameter("npery");
        }

        return request;
    }
}
