// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Vpp Token Sync Licenses Request.
 */
public class BaseVppTokenSyncLicensesRequest extends BaseRequest implements IBaseVppTokenSyncLicensesRequest {

    /**
     * The request for this VppTokenSyncLicenses
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseVppTokenSyncLicensesRequest(final String requestUrl, final IBaseClient client, final java.util.List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, VppToken.class);
    }

    /**
     * Creates the VppTokenSyncLicenses
     *
     * @param callback The callback to be called after success or failure.
     */
    public void post(final ICallback<VppToken> callback) {
        send(HttpMethod.POST, callback, null);
    }

    /**
     * Creates the VppTokenSyncLicenses
     *
     * @return The VppToken
     * @throws ClientException An exception occurs if there was an error while the request was sent.
     */
    public VppToken post() throws ClientException {
       return send(HttpMethod.POST, null);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    public IVppTokenSyncLicensesRequest select(final String value) {
        getQueryOptions().add(new QueryOption("$select", value));
        return (VppTokenSyncLicensesRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    public IVppTokenSyncLicensesRequest expand(final String value) {
        getQueryOptions().add(new QueryOption("$expand", value));
        return (VppTokenSyncLicensesRequest)this;
    }

}
