// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

import com.google.gson.JsonObject;
import com.google.gson.JsonElement;
import com.google.gson.annotations.*;
import java.util.HashMap;
import java.util.Map;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Visual Info.
 */
public class BaseVisualInfo implements IJsonBackedObject {

    @SerializedName("@odata.type")
    @Expose
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    public final AdditionalDataManager getAdditionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Attribution.
     * Optional. JSON object used to represent an icon which represents the application used to generate the activity
     */
    @SerializedName("attribution")
    @Expose
    public ImageInfo attribution;

    /**
     * The Background Color.
     * Optional. Background color used to render the activity in the UI - brand color for the application source of the activity
     */
    @SerializedName("backgroundColor")
    @Expose
    public String backgroundColor;

    /**
     * The Description.
     * Optional. Longer text description of the user's unique activity (example: document name, first sentence, and/or metadata)
     */
    @SerializedName("description")
    @Expose
    public String description;

    /**
     * The Display Text.
     * Rquired. Short text description of the user's unique activity (for example, document name in cases where an activity refers to document creation)
     */
    @SerializedName("displayText")
    @Expose
    public String displayText;

    /**
     * The Content.
     * Optional. Custom piece of data - JSON object used to provide custom content to render the activity in the Windows Shell UI
     */
    @SerializedName("content")
    @Expose
    public com.google.gson.JsonElement content;


    /**
     * The raw representation of this class
     */
    private transient JsonObject mRawObject;

    /**
     * The serializer
     */
    private transient ISerializer mSerializer;

    /**
     * Gets the raw representation of this class
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return mRawObject;
    }

    /**
     * Gets serializer
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return mSerializer;
    }

    /**
     * Sets the raw json object
     *
     * @param serializer The serializer
     * @param json The json object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        mSerializer = serializer;
        mRawObject = json;

    }
}
