// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

import com.google.gson.JsonObject;
import com.google.gson.annotations.*;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base User Find Meeting Times Body.
 */
public class BaseUserFindMeetingTimesBody {

    /**
     * The attendees.
     * 
     */
    @SerializedName("attendees")
    @Expose
    public java.util.List<AttendeeBase> attendees;

    /**
     * The location Constraint.
     * 
     */
    @SerializedName("locationConstraint")
    @Expose
    public LocationConstraint locationConstraint;

    /**
     * The time Constraint.
     * 
     */
    @SerializedName("timeConstraint")
    @Expose
    public TimeConstraint timeConstraint;

    /**
     * The meeting Duration.
     * 
     */
    @SerializedName("meetingDuration")
    @Expose
    public javax.xml.datatype.Duration meetingDuration;

    /**
     * The max Candidates.
     * 
     */
    @SerializedName("maxCandidates")
    @Expose
    public Integer maxCandidates;

    /**
     * The is Organizer Optional.
     * 
     */
    @SerializedName("isOrganizerOptional")
    @Expose
    public Boolean isOrganizerOptional;

    /**
     * The return Suggestion Reasons.
     * 
     */
    @SerializedName("returnSuggestionReasons")
    @Expose
    public Boolean returnSuggestionReasons;

    /**
     * The minimum Attendee Percentage.
     * 
     */
    @SerializedName("minimumAttendeePercentage")
    @Expose
    public Double minimumAttendeePercentage;


    /**
     * The raw representation of this class
     */
    private transient JsonObject mRawObject;

    /**
     * The serializer
     */
    private transient ISerializer mSerializer;

    /**
     * Gets the raw representation of this class
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return mRawObject;
    }

    /**
     * Gets serializer
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return mSerializer;
    }

    /**
     * Sets the raw json object
     *
     * @param serializer The serializer
     * @param json The json object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        mSerializer = serializer;
        mRawObject = json;

    }
}
