// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

// **NOTE** This file was generated by a tool and any changes will be overwritten.
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Schema Extension Collection Request.
 */
public class BaseSchemaExtensionCollectionRequest extends BaseCollectionRequest<BaseSchemaExtensionCollectionResponse, ISchemaExtensionCollectionPage> implements IBaseSchemaExtensionCollectionRequest {

    /**
     * The request builder for this collection of SchemaExtension
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseSchemaExtensionCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseSchemaExtensionCollectionResponse.class, ISchemaExtensionCollectionPage.class);
    }

    public void get(final ICallback<ISchemaExtensionCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public ISchemaExtensionCollectionPage get() throws ClientException {
        final BaseSchemaExtensionCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final SchemaExtension newSchemaExtension, final ICallback<SchemaExtension> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new SchemaExtensionRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newSchemaExtension, callback);
    }

    public SchemaExtension post(final SchemaExtension newSchemaExtension) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new SchemaExtensionRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newSchemaExtension);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    public ISchemaExtensionCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (SchemaExtensionCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    public ISchemaExtensionCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (SchemaExtensionCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value The max number of items to return
     * @return The updated request
     */
    public ISchemaExtensionCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value + ""));
        return (SchemaExtensionCollectionRequest)this;
    }

    public ISchemaExtensionCollectionPage buildFromResponse(final BaseSchemaExtensionCollectionResponse response) {
        final ISchemaExtensionCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new SchemaExtensionCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final SchemaExtensionCollectionPage page = new SchemaExtensionCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
