// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

import com.google.gson.JsonObject;
import com.google.gson.JsonElement;
import com.google.gson.annotations.*;
import java.util.HashMap;
import java.util.Map;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Recurrence Range.
 */
public class BaseRecurrenceRange implements IJsonBackedObject {

    @SerializedName("@odata.type")
    @Expose
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    public final AdditionalDataManager getAdditionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Type.
     * The recurrence range. Possible values are: endDate, noEnd, numbered. Required.
     */
    @SerializedName("type")
    @Expose
    public RecurrenceRangeType type;

    /**
     * The Start Date.
     * The date to start applying the recurrence pattern. The first occurrence of the meeting may be this date or later, depending on the recurrence pattern of the event. Must be the same value as the start property of the recurring event. Required.
     */
    @SerializedName("startDate")
    @Expose
    public com.microsoft.graph.model.DateOnly startDate;

    /**
     * The End Date.
     * The date to stop applying the recurrence pattern. Depending on the recurrence pattern of the event, the last occurrence of the meeting may not be this date. Required if type is endDate.
     */
    @SerializedName("endDate")
    @Expose
    public com.microsoft.graph.model.DateOnly endDate;

    /**
     * The Recurrence Time Zone.
     * Time zone for the startDate and endDate properties. Optional. If not specified, the time zone of the event is used.
     */
    @SerializedName("recurrenceTimeZone")
    @Expose
    public String recurrenceTimeZone;

    /**
     * The Number Of Occurrences.
     * The number of times to repeat the event. Required and must be positive if type is numbered.
     */
    @SerializedName("numberOfOccurrences")
    @Expose
    public Integer numberOfOccurrences;


    /**
     * The raw representation of this class
     */
    private transient JsonObject mRawObject;

    /**
     * The serializer
     */
    private transient ISerializer mSerializer;

    /**
     * Gets the raw representation of this class
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return mRawObject;
    }

    /**
     * Gets serializer
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return mSerializer;
    }

    /**
     * Sets the raw json object
     *
     * @param serializer The serializer
     * @param json The json object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        mSerializer = serializer;
        mRawObject = json;

    }
}
