// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Onenote Page Copy To Section Request Builder.
 */
public class BaseOnenotePageCopyToSectionRequestBuilder extends BaseActionRequestBuilder {

    /**
     * The request builder for this OnenotePageCopyToSection
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseOnenotePageCopyToSectionRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<Option> requestOptions, final String id, final String groupId, final String siteCollectionId, final String siteId) {
        super(requestUrl, client, requestOptions);
        mBodyParams.put("id", id);
        mBodyParams.put("groupId", groupId);
        mBodyParams.put("siteCollectionId", siteCollectionId);
        mBodyParams.put("siteId", siteId);
    }

    /**
     * Creates the IOnenotePageCopyToSectionRequest
     *
     * @return The IOnenotePageCopyToSectionRequest instance
     */
    public IOnenotePageCopyToSectionRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IOnenotePageCopyToSectionRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return The IOnenotePageCopyToSectionRequest instance
     */
    public IOnenotePageCopyToSectionRequest buildRequest(final java.util.List<Option> requestOptions) {
        OnenotePageCopyToSectionRequest request = new OnenotePageCopyToSectionRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("id")) {
            request.mBody.id = getParameter("id");
        }

        if (hasParameter("groupId")) {
            request.mBody.groupId = getParameter("groupId");
        }

        if (hasParameter("siteCollectionId")) {
            request.mBody.siteCollectionId = getParameter("siteCollectionId");
        }

        if (hasParameter("siteId")) {
            request.mBody.siteId = getParameter("siteId");
        }

        return request;
    }
}
