// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

// **NOTE** This file was generated by a tool and any changes will be overwritten.
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Notebook Collection Request.
 */
public class BaseNotebookCollectionRequest extends BaseCollectionRequest<BaseNotebookCollectionResponse, INotebookCollectionPage> implements IBaseNotebookCollectionRequest {

    /**
     * The request builder for this collection of Notebook
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseNotebookCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseNotebookCollectionResponse.class, INotebookCollectionPage.class);
    }

    public void get(final ICallback<INotebookCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public INotebookCollectionPage get() throws ClientException {
        final BaseNotebookCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final Notebook newNotebook, final ICallback<Notebook> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new NotebookRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newNotebook, callback);
    }

    public Notebook post(final Notebook newNotebook) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new NotebookRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newNotebook);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    public INotebookCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (NotebookCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    public INotebookCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (NotebookCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value The max number of items to return
     * @return The updated request
     */
    public INotebookCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value + ""));
        return (NotebookCollectionRequest)this;
    }

    public INotebookCollectionPage buildFromResponse(final BaseNotebookCollectionResponse response) {
        final INotebookCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new NotebookCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final NotebookCollectionPage page = new NotebookCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
