// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Message Send Request Builder.
 */
public class BaseMessageSendRequestBuilder extends BaseActionRequestBuilder {

    /**
     * The request builder for this MessageSend
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseMessageSendRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the IMessageSendRequest
     *
     * @return The IMessageSendRequest instance
     */
    public IMessageSendRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IMessageSendRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return The IMessageSendRequest instance
     */
    public IMessageSendRequest buildRequest(final java.util.List<Option> requestOptions) {
        MessageSendRequest request = new MessageSendRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        return request;
    }
}
