// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

import com.google.gson.JsonObject;
import com.google.gson.JsonElement;
import com.google.gson.annotations.*;
import java.util.HashMap;
import java.util.Map;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Message Rule Predicates.
 */
public class BaseMessageRulePredicates implements IJsonBackedObject {

    @SerializedName("@odata.type")
    @Expose
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    public final AdditionalDataManager getAdditionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Categories.
     * Represents the categories that an incoming message should be labeled with in order for the condition or exception to apply.
     */
    @SerializedName("categories")
    @Expose
    public java.util.List<String> categories;

    /**
     * The Subject Contains.
     * Represents the strings that appear in the subject of an incoming message in order for the condition or exception to apply.
     */
    @SerializedName("subjectContains")
    @Expose
    public java.util.List<String> subjectContains;

    /**
     * The Body Contains.
     * Represents the strings that should appear in the body of an incoming message in order for the condition or exception to apply.
     */
    @SerializedName("bodyContains")
    @Expose
    public java.util.List<String> bodyContains;

    /**
     * The Body Or Subject Contains.
     * Represents the strings that should appear in the body or subject of an incoming message in order for the condition or exception to apply.
     */
    @SerializedName("bodyOrSubjectContains")
    @Expose
    public java.util.List<String> bodyOrSubjectContains;

    /**
     * The Sender Contains.
     * Represents the strings that appear in the from property of an incoming message in order for the condition or exception to apply.
     */
    @SerializedName("senderContains")
    @Expose
    public java.util.List<String> senderContains;

    /**
     * The Recipient Contains.
     * Represents the strings that appear in either the toRecipients or ccRecipients properties of an incoming message in order for the condition or exception to apply.
     */
    @SerializedName("recipientContains")
    @Expose
    public java.util.List<String> recipientContains;

    /**
     * The Header Contains.
     * Represents the strings that appear in the headers of an incoming message in order for the condition or exception to apply.
     */
    @SerializedName("headerContains")
    @Expose
    public java.util.List<String> headerContains;

    /**
     * The Message Action Flag.
     * Represents the flag-for-action value that appears on an incoming message in order for the condition or exception to apply. Possible values are: any, call, doNotForward, followUp, fyi, forward, noResponseNecessary, read, reply, replyToAll, review.
     */
    @SerializedName("messageActionFlag")
    @Expose
    public MessageActionFlag messageActionFlag;

    /**
     * The Importance.
     * The importance that is stamped on an incoming message in order for the condition or exception to apply: low, normal, high.
     */
    @SerializedName("importance")
    @Expose
    public Importance importance;

    /**
     * The Sensitivity.
     * Represents the sensitivity level that must be stamped on an incoming message in order for the condition or exception to apply. Possible values are: normal, personal, private, confidential.
     */
    @SerializedName("sensitivity")
    @Expose
    public Sensitivity sensitivity;

    /**
     * The From Addresses.
     * Represents the specific sender email addresses of an incoming message in order for the condition or exception to apply.
     */
    @SerializedName("fromAddresses")
    @Expose
    public java.util.List<Recipient> fromAddresses;

    /**
     * The Sent To Addresses.
     * Represents the email addresses that an incoming message must have been sent to in order for the condition or exception to apply.
     */
    @SerializedName("sentToAddresses")
    @Expose
    public java.util.List<Recipient> sentToAddresses;

    /**
     * The Sent To Me.
     * Indicates whether the owner of the mailbox must be in the toRecipients property of an incoming message in order for the condition or exception to apply.
     */
    @SerializedName("sentToMe")
    @Expose
    public Boolean sentToMe;

    /**
     * The Sent Only To Me.
     * Indicates whether the owner of the mailbox must be the only recipient in an incoming message in order for the condition or exception to apply.
     */
    @SerializedName("sentOnlyToMe")
    @Expose
    public Boolean sentOnlyToMe;

    /**
     * The Sent Cc Me.
     * Indicates whether the owner of the mailbox must be in the ccRecipients property of an incoming message in order for the condition or exception to apply.
     */
    @SerializedName("sentCcMe")
    @Expose
    public Boolean sentCcMe;

    /**
     * The Sent To Or Cc Me.
     * Indicates whether the owner of the mailbox must be in either a toRecipients or ccRecipients property of an incoming message in order for the condition or exception to apply.
     */
    @SerializedName("sentToOrCcMe")
    @Expose
    public Boolean sentToOrCcMe;

    /**
     * The Not Sent To Me.
     * Indicates whether the owner of the mailbox must not be a recipient of an incoming message in order for the condition or exception to apply.
     */
    @SerializedName("notSentToMe")
    @Expose
    public Boolean notSentToMe;

    /**
     * The Has Attachments.
     * Indicates whether an incoming message must have attachments in order for the condition or exception to apply.
     */
    @SerializedName("hasAttachments")
    @Expose
    public Boolean hasAttachments;

    /**
     * The Is Approval Request.
     * Indicates whether an incoming message must be an approval request in order for the condition or exception to apply.
     */
    @SerializedName("isApprovalRequest")
    @Expose
    public Boolean isApprovalRequest;

    /**
     * The Is Automatic Forward.
     * Indicates whether an incoming message must be automatically forwarded in order for the condition or exception to apply.
     */
    @SerializedName("isAutomaticForward")
    @Expose
    public Boolean isAutomaticForward;

    /**
     * The Is Automatic Reply.
     * Indicates whether an incoming message must be an auto reply in order for the condition or exception to apply.
     */
    @SerializedName("isAutomaticReply")
    @Expose
    public Boolean isAutomaticReply;

    /**
     * The Is Encrypted.
     * Indicates whether an incoming message must be encrypted in order for the condition or exception to apply.
     */
    @SerializedName("isEncrypted")
    @Expose
    public Boolean isEncrypted;

    /**
     * The Is Meeting Request.
     * Indicates whether an incoming message must be a meeting request in order for the condition or exception to apply.
     */
    @SerializedName("isMeetingRequest")
    @Expose
    public Boolean isMeetingRequest;

    /**
     * The Is Meeting Response.
     * Indicates whether an incoming message must be a meeting response in order for the condition or exception to apply.
     */
    @SerializedName("isMeetingResponse")
    @Expose
    public Boolean isMeetingResponse;

    /**
     * The Is Non Delivery Report.
     * Indicates whether an incoming message must be a non-delivery report in order for the condition or exception to apply.
     */
    @SerializedName("isNonDeliveryReport")
    @Expose
    public Boolean isNonDeliveryReport;

    /**
     * The Is Permission Controlled.
     * Indicates whether an incoming message must be permission controlled (RMS-protected) in order for the condition or exception to apply.
     */
    @SerializedName("isPermissionControlled")
    @Expose
    public Boolean isPermissionControlled;

    /**
     * The Is Read Receipt.
     * Indicates whether an incoming message must be a read receipt in order for the condition or exception to apply.
     */
    @SerializedName("isReadReceipt")
    @Expose
    public Boolean isReadReceipt;

    /**
     * The Is Signed.
     * Indicates whether an incoming message must be S/MIME-signed in order for the condition or exception to apply.
     */
    @SerializedName("isSigned")
    @Expose
    public Boolean isSigned;

    /**
     * The Is Voicemail.
     * Indicates whether an incoming message must be a voice mail in order for the condition or exception to apply.
     */
    @SerializedName("isVoicemail")
    @Expose
    public Boolean isVoicemail;

    /**
     * The Within Size Range.
     * Represents the minimum and maximum sizes (in kilobytes) that an incoming message must fall in between in order for the condition or exception to apply.
     */
    @SerializedName("withinSizeRange")
    @Expose
    public SizeRange withinSizeRange;


    /**
     * The raw representation of this class
     */
    private transient JsonObject mRawObject;

    /**
     * The serializer
     */
    private transient ISerializer mSerializer;

    /**
     * Gets the raw representation of this class
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return mRawObject;
    }

    /**
     * Gets serializer
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return mSerializer;
    }

    /**
     * Sets the raw json object
     *
     * @param serializer The serializer
     * @param json The json object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        mSerializer = serializer;
        mRawObject = json;

    }
}
