// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Group Lifecycle Policy Request Builder.
 */
public class BaseGroupLifecyclePolicyRequestBuilder extends BaseRequestBuilder implements IBaseGroupLifecyclePolicyRequestBuilder {

    /**
     * The request builder for the GroupLifecyclePolicy
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseGroupLifecyclePolicyRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     */
    public IGroupLifecyclePolicyRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     */
    public IGroupLifecyclePolicyRequest buildRequest(final java.util.List<Option> requestOptions) {
        return new GroupLifecyclePolicyRequest(getRequestUrl(), getClient(), requestOptions);
    }


    public IGroupLifecyclePolicyAddGroupRequestBuilder getAddGroup(final String groupId) {
        return new GroupLifecyclePolicyAddGroupRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.addGroup"), getClient(), null, groupId);
    }

    public IGroupLifecyclePolicyRemoveGroupRequestBuilder getRemoveGroup(final String groupId) {
        return new GroupLifecyclePolicyRemoveGroupRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.removeGroup"), getClient(), null, groupId);
    }
}
