// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

// **NOTE** This file was generated by a tool and any changes will be overwritten.
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Group Lifecycle Policy Collection Request.
 */
public class BaseGroupLifecyclePolicyCollectionRequest extends BaseCollectionRequest<BaseGroupLifecyclePolicyCollectionResponse, IGroupLifecyclePolicyCollectionPage> implements IBaseGroupLifecyclePolicyCollectionRequest {

    /**
     * The request builder for this collection of GroupLifecyclePolicy
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseGroupLifecyclePolicyCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseGroupLifecyclePolicyCollectionResponse.class, IGroupLifecyclePolicyCollectionPage.class);
    }

    public void get(final ICallback<IGroupLifecyclePolicyCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IGroupLifecyclePolicyCollectionPage get() throws ClientException {
        final BaseGroupLifecyclePolicyCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final GroupLifecyclePolicy newGroupLifecyclePolicy, final ICallback<GroupLifecyclePolicy> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new GroupLifecyclePolicyRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newGroupLifecyclePolicy, callback);
    }

    public GroupLifecyclePolicy post(final GroupLifecyclePolicy newGroupLifecyclePolicy) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new GroupLifecyclePolicyRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newGroupLifecyclePolicy);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    public IGroupLifecyclePolicyCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (GroupLifecyclePolicyCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    public IGroupLifecyclePolicyCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (GroupLifecyclePolicyCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value The max number of items to return
     * @return The updated request
     */
    public IGroupLifecyclePolicyCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value + ""));
        return (GroupLifecyclePolicyCollectionRequest)this;
    }

    public IGroupLifecyclePolicyCollectionPage buildFromResponse(final BaseGroupLifecyclePolicyCollectionResponse response) {
        final IGroupLifecyclePolicyCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new GroupLifecyclePolicyCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final GroupLifecyclePolicyCollectionPage page = new GroupLifecyclePolicyCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
