// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Education User Reference Request.
 */
public class BaseEducationUserReferenceRequest extends BaseRequest implements IBaseEducationUserReferenceRequest {

    /**
     * The request for the EducationUser
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseEducationUserReferenceRequest(String requestUrl, IBaseClient client, java.util.List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, EducationUser.class);
    }

    public void delete(final ICallback<EducationUser> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    public EducationUser delete() throws ClientException {
       return send(HttpMethod.DELETE, null);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    public IEducationUserReferenceRequest select(final String value) {
        getQueryOptions().add(new QueryOption("$select", value));
        return (EducationUserReferenceRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    public IEducationUserReferenceRequest expand(final String value) {
        getQueryOptions().add(new QueryOption("$expand", value));
        return (EducationUserReferenceRequest)this;
    }
    /**
     * Puts the EducationUser
     *
     * @param srcEducationUser The EducationUser reference to PUT
     * @param callback The callback to be called after success or failure
     */
    public void put(EducationUser srcEducationUser, final ICallback<EducationUser> callback) {
        send(HttpMethod.PUT, callback, srcEducationUser);
    }

    /**
     * Puts the EducationUser
     *
     * @param srcEducationUser The EducationUser reference to PUT
     * @return The EducationUser
     * @throws ClientException An exception occurs if there was an error while the request was sent
     */
    public EducationUser put(EducationUser srcEducationUser) throws ClientException {
        return send(HttpMethod.PUT, srcEducationUser);
    }
}
