// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

// **NOTE** This file was generated by a tool and any changes will be overwritten.
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Education User Collection With References Request.
 */
public class BaseEducationUserCollectionWithReferencesRequest extends BaseCollectionRequest<BaseEducationUserCollectionResponse, IEducationUserCollectionPage> implements IBaseEducationUserCollectionWithReferencesRequest {

    /**
     * The request builder for this collection of EducationUser
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseEducationUserCollectionWithReferencesRequest(final String requestUrl, IBaseClient client, final java.util.List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseEducationUserCollectionResponse.class, IEducationUserCollectionPage.class);
    }

    public void get(final ICallback<IEducationUserCollectionWithReferencesPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IEducationUserCollectionWithReferencesPage get() throws ClientException {
        final BaseEducationUserCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public IEducationUserCollectionWithReferencesRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (EducationUserCollectionWithReferencesRequest)this;
    }

    public IEducationUserCollectionWithReferencesRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (EducationUserCollectionWithReferencesRequest)this;
    }

    public IEducationUserCollectionWithReferencesRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value + ""));
        return (EducationUserCollectionWithReferencesRequest)this;
    }

    public IEducationUserCollectionWithReferencesPage buildFromResponse(final BaseEducationUserCollectionResponse response) {
        final IEducationUserCollectionWithReferencesRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new EducationUserCollectionWithReferencesRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final EducationUserCollectionWithReferencesPage page = new EducationUserCollectionWithReferencesPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
