// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

import com.google.gson.JsonObject;
import com.google.gson.JsonElement;
import com.google.gson.annotations.*;
import java.util.HashMap;
import java.util.Map;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Education School.
 */
public class BaseEducationSchool extends EducationOrganization implements IJsonBackedObject {


    /**
     * The Principal Email.
     * Email address of the principal.
     */
    @SerializedName("principalEmail")
    @Expose
    public String principalEmail;

    /**
     * The Principal Name.
     * Name of the principal.
     */
    @SerializedName("principalName")
    @Expose
    public String principalName;

    /**
     * The External Principal Id.
     * ID of principal in syncing system.
     */
    @SerializedName("externalPrincipalId")
    @Expose
    public String externalPrincipalId;

    /**
     * The Lowest Grade.
     * Lowest grade taught.
     */
    @SerializedName("lowestGrade")
    @Expose
    public String lowestGrade;

    /**
     * The Highest Grade.
     * Highest grade taught.
     */
    @SerializedName("highestGrade")
    @Expose
    public String highestGrade;

    /**
     * The School Number.
     * School Number.
     */
    @SerializedName("schoolNumber")
    @Expose
    public String schoolNumber;

    /**
     * The External Id.
     * ID of school in syncing system.
     */
    @SerializedName("externalId")
    @Expose
    public String externalId;

    /**
     * The Phone.
     * Phone number of school.
     */
    @SerializedName("phone")
    @Expose
    public String phone;

    /**
     * The Fax.
     * Fax number of school.
     */
    @SerializedName("fax")
    @Expose
    public String fax;

    /**
     * The Created By.
     * Entity who created the school.
     */
    @SerializedName("createdBy")
    @Expose
    public IdentitySet createdBy;

    /**
     * The Address.
     * Address of the school.
     */
    @SerializedName("address")
    @Expose
    public PhysicalAddress address;

    /**
     * The Classes.
     * Classes taught at the school. Nullable.
     */
    public transient EducationClassCollectionPage classes;

    /**
     * The Users.
     * Users in the school. Nullable.
     */
    public transient EducationUserCollectionPage users;

    /**
     * The Administrative Unit.
     * 
     */
    @SerializedName("administrativeUnit")
    @Expose
    public AdministrativeUnit administrativeUnit;


    /**
     * The raw representation of this class
     */
    private transient JsonObject mRawObject;

    /**
     * The serializer
     */
    private transient ISerializer mSerializer;

    /**
     * Gets the raw representation of this class
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return mRawObject;
    }

    /**
     * Gets serializer
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return mSerializer;
    }

    /**
     * Sets the raw json object
     *
     * @param serializer The serializer
     * @param json The json object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        mSerializer = serializer;
        mRawObject = json;


        if (json.has("classes")) {
            final BaseEducationClassCollectionResponse response = new BaseEducationClassCollectionResponse();
            if (json.has("classes@odata.nextLink")) {
                response.nextLink = json.get("classes@odata.nextLink").getAsString();
            }

            final JsonObject[] sourceArray = serializer.deserializeObject(json.get("classes").toString(), JsonObject[].class);
            final EducationClass[] array = new EducationClass[sourceArray.length];
            for (int i = 0; i < sourceArray.length; i++) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), EducationClass.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            classes = new EducationClassCollectionPage(response, null);
        }

        if (json.has("users")) {
            final BaseEducationUserCollectionResponse response = new BaseEducationUserCollectionResponse();
            if (json.has("users@odata.nextLink")) {
                response.nextLink = json.get("users@odata.nextLink").getAsString();
            }

            final JsonObject[] sourceArray = serializer.deserializeObject(json.get("users").toString(), JsonObject[].class);
            final EducationUser[] array = new EducationUser[sourceArray.length];
            for (int i = 0; i < sourceArray.length; i++) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), EducationUser.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            users = new EducationUserCollectionPage(response, null);
        }
    }
}
