// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Education Root Request Builder.
 */
public class BaseEducationRootRequestBuilder extends BaseRequestBuilder implements IBaseEducationRootRequestBuilder {

    /**
     * The request builder for the EducationRoot
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseEducationRootRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     */
    public IEducationRootRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     */
    public IEducationRootRequest buildRequest(final java.util.List<Option> requestOptions) {
        return new EducationRootRequest(getRequestUrl(), getClient(), requestOptions);
    }

    public IEducationClassCollectionRequestBuilder getClasses() {
        return new EducationClassCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("classes"), getClient(), null);
    }

    public IEducationClassRequestBuilder getClasses(final String id) {
        return new EducationClassRequestBuilder(getRequestUrlWithAdditionalSegment("classes") + "/" + id, getClient(), null);
    }
    public IEducationSchoolCollectionRequestBuilder getSchools() {
        return new EducationSchoolCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("schools"), getClient(), null);
    }

    public IEducationSchoolRequestBuilder getSchools(final String id) {
        return new EducationSchoolRequestBuilder(getRequestUrlWithAdditionalSegment("schools") + "/" + id, getClient(), null);
    }
    public IEducationUserCollectionRequestBuilder getUsers() {
        return new EducationUserCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("users"), getClient(), null);
    }

    public IEducationUserRequestBuilder getUsers(final String id) {
        return new EducationUserRequestBuilder(getRequestUrlWithAdditionalSegment("users") + "/" + id, getClient(), null);
    }

    /**
     * Gets the request builder for EducationUser.
     */
    public IEducationUserRequestBuilder getMe() {
        return new EducationUserRequestBuilder(getRequestUrlWithAdditionalSegment("me"), getClient(), null);
    }
}
