// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Education Organization Request.
 */
public class BaseEducationOrganizationRequest extends BaseRequest implements IBaseEducationOrganizationRequest {

    /**
     * The request for the EducationOrganization
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     * @param responseClass The class of the reponse
     */
    public BaseEducationOrganizationRequest(final String requestUrl,
            final IBaseClient client,
            final java.util.List<Option> requestOptions,
            final Class responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * Gets the EducationOrganization from the service
     * @param callback The callback to be called after success or failure.
     */
    public void getEducationOrganization(final ICallback<EducationOrganization> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the EducationOrganization from the service
     * @return The EducationOrganization from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public EducationOrganization getEducationOrganization() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    public void delete(final ICallback<Void> callback) {{
        send(HttpMethod.DELETE, callback, null);
    }}

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {{
        send(HttpMethod.DELETE, null);
    }}

    /**
     * Patches this EducationOrganization with a source
     * @param sourceEducationOrganization The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    public void patch(final EducationOrganization sourceEducationOrganization, final ICallback<EducationOrganization> callback) {
        send(HttpMethod.PATCH, callback, sourceEducationOrganization);
    }

    /**
     * Patches this EducationOrganization with a source
     * @param sourceEducationOrganization The source object with updates
     * @return The updated EducationOrganization
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public EducationOrganization patch(final EducationOrganization sourceEducationOrganization) throws ClientException {
        return send(HttpMethod.PATCH, sourceEducationOrganization);
    }

    /**
     * Creates a EducationOrganization with a new object
     * @param newEducationOrganization The new object to create
     * @param callback The callback to be called after success or failure.
     */
    public void post(final EducationOrganization newEducationOrganization, final ICallback<EducationOrganization> callback) {
        send(HttpMethod.POST, callback, newEducationOrganization);
    }

    /**
     * Creates a EducationOrganization with a new object
     * @param newEducationOrganization The new object to create
     * @return The created EducationOrganization
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public EducationOrganization post(final EducationOrganization newEducationOrganization) throws ClientException {
        return send(HttpMethod.POST, newEducationOrganization);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
     public IEducationOrganizationRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (EducationOrganizationRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
     public IEducationOrganizationRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (EducationOrganizationRequest)this;
     }

}

