// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Directory Request.
 */
public class BaseDirectoryRequest extends BaseRequest implements IBaseDirectoryRequest {

    /**
     * The request for the Directory
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     * @param responseClass The class of the reponse
     */
    public BaseDirectoryRequest(final String requestUrl,
            final IBaseClient client,
            final java.util.List<Option> requestOptions,
            final Class responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * Gets the Directory from the service
     * @param callback The callback to be called after success or failure.
     */
    public void get(final ICallback<Directory> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the Directory from the service
     * @return The Directory from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public Directory get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    public void delete(final ICallback<Void> callback) {{
        send(HttpMethod.DELETE, callback, null);
    }}

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {{
        send(HttpMethod.DELETE, null);
    }}

    /**
     * Patches this Directory with a source
     * @param sourceDirectory The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    public void patch(final Directory sourceDirectory, final ICallback<Directory> callback) {
        send(HttpMethod.PATCH, callback, sourceDirectory);
    }

    /**
     * Patches this Directory with a source
     * @param sourceDirectory The source object with updates
     * @return The updated Directory
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public Directory patch(final Directory sourceDirectory) throws ClientException {
        return send(HttpMethod.PATCH, sourceDirectory);
    }

    /**
     * Creates a Directory with a new object
     * @param newDirectory The new object to create
     * @param callback The callback to be called after success or failure.
     */
    public void post(final Directory newDirectory, final ICallback<Directory> callback) {
        send(HttpMethod.POST, callback, newDirectory);
    }

    /**
     * Creates a Directory with a new object
     * @param newDirectory The new object to create
     * @return The created Directory
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public Directory post(final Directory newDirectory) throws ClientException {
        return send(HttpMethod.POST, newDirectory);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
     public IDirectoryRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (DirectoryRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
     public IDirectoryRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (DirectoryRequest)this;
     }

}

