// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Base Item Request.
 */
public class BaseBaseItemRequest extends BaseRequest implements IBaseBaseItemRequest {

    /**
     * The request for the BaseItem
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     * @param responseClass The class of the reponse
     */
    public BaseBaseItemRequest(final String requestUrl,
            final IBaseClient client,
            final java.util.List<Option> requestOptions,
            final Class responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * Gets the BaseItem from the service
     * @param callback The callback to be called after success or failure.
     */
    public void getBaseItem(final ICallback<BaseItem> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the BaseItem from the service
     * @return The BaseItem from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public BaseItem getBaseItem() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    public void delete(final ICallback<Void> callback) {{
        send(HttpMethod.DELETE, callback, null);
    }}

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {{
        send(HttpMethod.DELETE, null);
    }}

    /**
     * Patches this BaseItem with a source
     * @param sourceBaseItem The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    public void patch(final BaseItem sourceBaseItem, final ICallback<BaseItem> callback) {
        send(HttpMethod.PATCH, callback, sourceBaseItem);
    }

    /**
     * Patches this BaseItem with a source
     * @param sourceBaseItem The source object with updates
     * @return The updated BaseItem
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public BaseItem patch(final BaseItem sourceBaseItem) throws ClientException {
        return send(HttpMethod.PATCH, sourceBaseItem);
    }

    /**
     * Creates a BaseItem with a new object
     * @param newBaseItem The new object to create
     * @param callback The callback to be called after success or failure.
     */
    public void post(final BaseItem newBaseItem, final ICallback<BaseItem> callback) {
        send(HttpMethod.POST, callback, newBaseItem);
    }

    /**
     * Creates a BaseItem with a new object
     * @param newBaseItem The new object to create
     * @return The created BaseItem
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public BaseItem post(final BaseItem newBaseItem) throws ClientException {
        return send(HttpMethod.POST, newBaseItem);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
     public IBaseItemRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (BaseItemRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
     public IBaseItemRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (BaseItemRequest)this;
     }

}

