/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.extensions;

import com.microsoft.graph.authentication.IAuthenticationProvider;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IClientConfig;
import com.microsoft.graph.extensions.IGraphServiceClient;
import com.microsoft.graph.generated.BaseGraphServiceClient;
import com.microsoft.graph.http.IHttpProvider;
import com.microsoft.graph.logger.ILogger;
import com.microsoft.graph.serializer.ISerializer;

public class GraphServiceClient
extends BaseGraphServiceClient
implements IGraphServiceClient {
    protected GraphServiceClient() {
    }

    public static class Builder {
        private final GraphServiceClient mClient = new GraphServiceClient();

        public Builder serializer(ISerializer serializer) {
            this.mClient.setSerializer(serializer);
            return this;
        }

        public Builder httpProvider(IHttpProvider httpProvider) {
            this.mClient.setHttpProvider(httpProvider);
            return this;
        }

        public Builder authenticationProvider(IAuthenticationProvider authenticationProvider) {
            this.mClient.setAuthenticationProvider(authenticationProvider);
            return this;
        }

        public Builder executors(IExecutors executors) {
            this.mClient.setExecutors(executors);
            return this;
        }

        public Builder logger(ILogger logger) {
            this.mClient.setLogger(logger);
            return this;
        }

        public Builder fromConfig(IClientConfig clientConfig) {
            return this.authenticationProvider(clientConfig.getAuthenticationProvider()).executors(clientConfig.getExecutors()).httpProvider(clientConfig.getHttpProvider()).logger(clientConfig.getLogger()).serializer(clientConfig.getSerializer());
        }

        public IGraphServiceClient buildClient() throws ClientException {
            this.mClient.validate();
            return this.mClient;
        }
    }
}

