// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Workbook Functions Request Builder.
 */
public interface IBaseWorkbookFunctionsRequestBuilder extends IRequestBuilder {
    /**
     * Creates the request
     */
    IWorkbookFunctionsRequest buildRequest();

    /**
     * Creates the request with specific options instead of the existing options
     */
    IWorkbookFunctionsRequest buildRequest(final java.util.List<Option> requestOptions);
    IWorkbookFunctionsAbsRequestBuilder getAbs(final com.google.gson.JsonElement number);
    IWorkbookFunctionsAccrIntRequestBuilder getAccrInt(final com.google.gson.JsonElement issue, final com.google.gson.JsonElement firstInterest, final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement rate, final com.google.gson.JsonElement par, final com.google.gson.JsonElement frequency, final com.google.gson.JsonElement basis, final com.google.gson.JsonElement calcMethod);
    IWorkbookFunctionsAccrIntMRequestBuilder getAccrIntM(final com.google.gson.JsonElement issue, final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement rate, final com.google.gson.JsonElement par, final com.google.gson.JsonElement basis);
    IWorkbookFunctionsAcosRequestBuilder getAcos(final com.google.gson.JsonElement number);
    IWorkbookFunctionsAcoshRequestBuilder getAcosh(final com.google.gson.JsonElement number);
    IWorkbookFunctionsAcotRequestBuilder getAcot(final com.google.gson.JsonElement number);
    IWorkbookFunctionsAcothRequestBuilder getAcoth(final com.google.gson.JsonElement number);
    IWorkbookFunctionsAmorDegrcRequestBuilder getAmorDegrc(final com.google.gson.JsonElement cost, final com.google.gson.JsonElement datePurchased, final com.google.gson.JsonElement firstPeriod, final com.google.gson.JsonElement salvage, final com.google.gson.JsonElement period, final com.google.gson.JsonElement rate, final com.google.gson.JsonElement basis);
    IWorkbookFunctionsAmorLincRequestBuilder getAmorLinc(final com.google.gson.JsonElement cost, final com.google.gson.JsonElement datePurchased, final com.google.gson.JsonElement firstPeriod, final com.google.gson.JsonElement salvage, final com.google.gson.JsonElement period, final com.google.gson.JsonElement rate, final com.google.gson.JsonElement basis);
    IWorkbookFunctionsAndRequestBuilder getAnd(final com.google.gson.JsonElement values);
    IWorkbookFunctionsArabicRequestBuilder getArabic(final com.google.gson.JsonElement text);
    IWorkbookFunctionsAreasRequestBuilder getAreas(final com.google.gson.JsonElement reference);
    IWorkbookFunctionsAscRequestBuilder getAsc(final com.google.gson.JsonElement text);
    IWorkbookFunctionsAsinRequestBuilder getAsin(final com.google.gson.JsonElement number);
    IWorkbookFunctionsAsinhRequestBuilder getAsinh(final com.google.gson.JsonElement number);
    IWorkbookFunctionsAtanRequestBuilder getAtan(final com.google.gson.JsonElement number);
    IWorkbookFunctionsAtan2RequestBuilder getAtan2(final com.google.gson.JsonElement xNum, final com.google.gson.JsonElement yNum);
    IWorkbookFunctionsAtanhRequestBuilder getAtanh(final com.google.gson.JsonElement number);
    IWorkbookFunctionsAveDevRequestBuilder getAveDev(final com.google.gson.JsonElement values);
    IWorkbookFunctionsAverageRequestBuilder getAverage(final com.google.gson.JsonElement values);
    IWorkbookFunctionsAverageARequestBuilder getAverageA(final com.google.gson.JsonElement values);
    IWorkbookFunctionsAverageIfRequestBuilder getAverageIf(final com.google.gson.JsonElement range, final com.google.gson.JsonElement criteria, final com.google.gson.JsonElement averageRange);
    IWorkbookFunctionsAverageIfsRequestBuilder getAverageIfs(final com.google.gson.JsonElement averageRange, final com.google.gson.JsonElement values);
    IWorkbookFunctionsBahtTextRequestBuilder getBahtText(final com.google.gson.JsonElement number);
    IWorkbookFunctionsBaseRequestBuilder getBase(final com.google.gson.JsonElement number, final com.google.gson.JsonElement radix, final com.google.gson.JsonElement minLength);
    IWorkbookFunctionsBesselIRequestBuilder getBesselI(final com.google.gson.JsonElement x, final com.google.gson.JsonElement n);
    IWorkbookFunctionsBesselJRequestBuilder getBesselJ(final com.google.gson.JsonElement x, final com.google.gson.JsonElement n);
    IWorkbookFunctionsBesselKRequestBuilder getBesselK(final com.google.gson.JsonElement x, final com.google.gson.JsonElement n);
    IWorkbookFunctionsBesselYRequestBuilder getBesselY(final com.google.gson.JsonElement x, final com.google.gson.JsonElement n);
    IWorkbookFunctionsBeta_DistRequestBuilder getBeta_Dist(final com.google.gson.JsonElement x, final com.google.gson.JsonElement alpha, final com.google.gson.JsonElement beta, final com.google.gson.JsonElement cumulative, final com.google.gson.JsonElement a, final com.google.gson.JsonElement b);
    IWorkbookFunctionsBeta_InvRequestBuilder getBeta_Inv(final com.google.gson.JsonElement probability, final com.google.gson.JsonElement alpha, final com.google.gson.JsonElement beta, final com.google.gson.JsonElement a, final com.google.gson.JsonElement b);
    IWorkbookFunctionsBin2DecRequestBuilder getBin2Dec(final com.google.gson.JsonElement number);
    IWorkbookFunctionsBin2HexRequestBuilder getBin2Hex(final com.google.gson.JsonElement number, final com.google.gson.JsonElement places);
    IWorkbookFunctionsBin2OctRequestBuilder getBin2Oct(final com.google.gson.JsonElement number, final com.google.gson.JsonElement places);
    IWorkbookFunctionsBinom_DistRequestBuilder getBinom_Dist(final com.google.gson.JsonElement numberS, final com.google.gson.JsonElement trials, final com.google.gson.JsonElement probabilityS, final com.google.gson.JsonElement cumulative);
    IWorkbookFunctionsBinom_Dist_RangeRequestBuilder getBinom_Dist_Range(final com.google.gson.JsonElement trials, final com.google.gson.JsonElement probabilityS, final com.google.gson.JsonElement numberS, final com.google.gson.JsonElement numberS2);
    IWorkbookFunctionsBinom_InvRequestBuilder getBinom_Inv(final com.google.gson.JsonElement trials, final com.google.gson.JsonElement probabilityS, final com.google.gson.JsonElement alpha);
    IWorkbookFunctionsBitandRequestBuilder getBitand(final com.google.gson.JsonElement number1, final com.google.gson.JsonElement number2);
    IWorkbookFunctionsBitlshiftRequestBuilder getBitlshift(final com.google.gson.JsonElement number, final com.google.gson.JsonElement shiftAmount);
    IWorkbookFunctionsBitorRequestBuilder getBitor(final com.google.gson.JsonElement number1, final com.google.gson.JsonElement number2);
    IWorkbookFunctionsBitrshiftRequestBuilder getBitrshift(final com.google.gson.JsonElement number, final com.google.gson.JsonElement shiftAmount);
    IWorkbookFunctionsBitxorRequestBuilder getBitxor(final com.google.gson.JsonElement number1, final com.google.gson.JsonElement number2);
    IWorkbookFunctionsCeiling_MathRequestBuilder getCeiling_Math(final com.google.gson.JsonElement number, final com.google.gson.JsonElement significance, final com.google.gson.JsonElement mode);
    IWorkbookFunctionsCeiling_PreciseRequestBuilder getCeiling_Precise(final com.google.gson.JsonElement number, final com.google.gson.JsonElement significance);
    IWorkbookFunctionsCharRequestBuilder getChar(final com.google.gson.JsonElement number);
    IWorkbookFunctionsChiSq_DistRequestBuilder getChiSq_Dist(final com.google.gson.JsonElement x, final com.google.gson.JsonElement degFreedom, final com.google.gson.JsonElement cumulative);
    IWorkbookFunctionsChiSq_Dist_RTRequestBuilder getChiSq_Dist_RT(final com.google.gson.JsonElement x, final com.google.gson.JsonElement degFreedom);
    IWorkbookFunctionsChiSq_InvRequestBuilder getChiSq_Inv(final com.google.gson.JsonElement probability, final com.google.gson.JsonElement degFreedom);
    IWorkbookFunctionsChiSq_Inv_RTRequestBuilder getChiSq_Inv_RT(final com.google.gson.JsonElement probability, final com.google.gson.JsonElement degFreedom);
    IWorkbookFunctionsChooseRequestBuilder getChoose(final com.google.gson.JsonElement indexNum, final com.google.gson.JsonElement values);
    IWorkbookFunctionsCleanRequestBuilder getClean(final com.google.gson.JsonElement text);
    IWorkbookFunctionsCodeRequestBuilder getCode(final com.google.gson.JsonElement text);
    IWorkbookFunctionsColumnsRequestBuilder getColumns(final com.google.gson.JsonElement array);
    IWorkbookFunctionsCombinRequestBuilder getCombin(final com.google.gson.JsonElement number, final com.google.gson.JsonElement numberChosen);
    IWorkbookFunctionsCombinaRequestBuilder getCombina(final com.google.gson.JsonElement number, final com.google.gson.JsonElement numberChosen);
    IWorkbookFunctionsComplexRequestBuilder getComplex(final com.google.gson.JsonElement realNum, final com.google.gson.JsonElement iNum, final com.google.gson.JsonElement suffix);
    IWorkbookFunctionsConcatenateRequestBuilder getConcatenate(final com.google.gson.JsonElement values);
    IWorkbookFunctionsConfidence_NormRequestBuilder getConfidence_Norm(final com.google.gson.JsonElement alpha, final com.google.gson.JsonElement standardDev, final com.google.gson.JsonElement size);
    IWorkbookFunctionsConfidence_TRequestBuilder getConfidence_T(final com.google.gson.JsonElement alpha, final com.google.gson.JsonElement standardDev, final com.google.gson.JsonElement size);
    IWorkbookFunctionsConvertRequestBuilder getConvert(final com.google.gson.JsonElement number, final com.google.gson.JsonElement fromUnit, final com.google.gson.JsonElement toUnit);
    IWorkbookFunctionsCosRequestBuilder getCos(final com.google.gson.JsonElement number);
    IWorkbookFunctionsCoshRequestBuilder getCosh(final com.google.gson.JsonElement number);
    IWorkbookFunctionsCotRequestBuilder getCot(final com.google.gson.JsonElement number);
    IWorkbookFunctionsCothRequestBuilder getCoth(final com.google.gson.JsonElement number);
    IWorkbookFunctionsCountRequestBuilder getCount(final com.google.gson.JsonElement values);
    IWorkbookFunctionsCountARequestBuilder getCountA(final com.google.gson.JsonElement values);
    IWorkbookFunctionsCountBlankRequestBuilder getCountBlank(final com.google.gson.JsonElement range);
    IWorkbookFunctionsCountIfRequestBuilder getCountIf(final com.google.gson.JsonElement range, final com.google.gson.JsonElement criteria);
    IWorkbookFunctionsCountIfsRequestBuilder getCountIfs(final com.google.gson.JsonElement values);
    IWorkbookFunctionsCoupDayBsRequestBuilder getCoupDayBs(final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement maturity, final com.google.gson.JsonElement frequency, final com.google.gson.JsonElement basis);
    IWorkbookFunctionsCoupDaysRequestBuilder getCoupDays(final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement maturity, final com.google.gson.JsonElement frequency, final com.google.gson.JsonElement basis);
    IWorkbookFunctionsCoupDaysNcRequestBuilder getCoupDaysNc(final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement maturity, final com.google.gson.JsonElement frequency, final com.google.gson.JsonElement basis);
    IWorkbookFunctionsCoupNcdRequestBuilder getCoupNcd(final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement maturity, final com.google.gson.JsonElement frequency, final com.google.gson.JsonElement basis);
    IWorkbookFunctionsCoupNumRequestBuilder getCoupNum(final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement maturity, final com.google.gson.JsonElement frequency, final com.google.gson.JsonElement basis);
    IWorkbookFunctionsCoupPcdRequestBuilder getCoupPcd(final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement maturity, final com.google.gson.JsonElement frequency, final com.google.gson.JsonElement basis);
    IWorkbookFunctionsCscRequestBuilder getCsc(final com.google.gson.JsonElement number);
    IWorkbookFunctionsCschRequestBuilder getCsch(final com.google.gson.JsonElement number);
    IWorkbookFunctionsCumIPmtRequestBuilder getCumIPmt(final com.google.gson.JsonElement rate, final com.google.gson.JsonElement nper, final com.google.gson.JsonElement pv, final com.google.gson.JsonElement startPeriod, final com.google.gson.JsonElement endPeriod, final com.google.gson.JsonElement type);
    IWorkbookFunctionsCumPrincRequestBuilder getCumPrinc(final com.google.gson.JsonElement rate, final com.google.gson.JsonElement nper, final com.google.gson.JsonElement pv, final com.google.gson.JsonElement startPeriod, final com.google.gson.JsonElement endPeriod, final com.google.gson.JsonElement type);
    IWorkbookFunctionsDaverageRequestBuilder getDaverage(final com.google.gson.JsonElement database, final com.google.gson.JsonElement field, final com.google.gson.JsonElement criteria);
    IWorkbookFunctionsDcountRequestBuilder getDcount(final com.google.gson.JsonElement database, final com.google.gson.JsonElement field, final com.google.gson.JsonElement criteria);
    IWorkbookFunctionsDcountARequestBuilder getDcountA(final com.google.gson.JsonElement database, final com.google.gson.JsonElement field, final com.google.gson.JsonElement criteria);
    IWorkbookFunctionsDgetRequestBuilder getDget(final com.google.gson.JsonElement database, final com.google.gson.JsonElement field, final com.google.gson.JsonElement criteria);
    IWorkbookFunctionsDmaxRequestBuilder getDmax(final com.google.gson.JsonElement database, final com.google.gson.JsonElement field, final com.google.gson.JsonElement criteria);
    IWorkbookFunctionsDminRequestBuilder getDmin(final com.google.gson.JsonElement database, final com.google.gson.JsonElement field, final com.google.gson.JsonElement criteria);
    IWorkbookFunctionsDproductRequestBuilder getDproduct(final com.google.gson.JsonElement database, final com.google.gson.JsonElement field, final com.google.gson.JsonElement criteria);
    IWorkbookFunctionsDstDevRequestBuilder getDstDev(final com.google.gson.JsonElement database, final com.google.gson.JsonElement field, final com.google.gson.JsonElement criteria);
    IWorkbookFunctionsDstDevPRequestBuilder getDstDevP(final com.google.gson.JsonElement database, final com.google.gson.JsonElement field, final com.google.gson.JsonElement criteria);
    IWorkbookFunctionsDsumRequestBuilder getDsum(final com.google.gson.JsonElement database, final com.google.gson.JsonElement field, final com.google.gson.JsonElement criteria);
    IWorkbookFunctionsDvarRequestBuilder getDvar(final com.google.gson.JsonElement database, final com.google.gson.JsonElement field, final com.google.gson.JsonElement criteria);
    IWorkbookFunctionsDvarPRequestBuilder getDvarP(final com.google.gson.JsonElement database, final com.google.gson.JsonElement field, final com.google.gson.JsonElement criteria);
    IWorkbookFunctionsDateRequestBuilder getDate(final com.google.gson.JsonElement year, final com.google.gson.JsonElement month, final com.google.gson.JsonElement day);
    IWorkbookFunctionsDatevalueRequestBuilder getDatevalue(final com.google.gson.JsonElement dateText);
    IWorkbookFunctionsDayRequestBuilder getDay(final com.google.gson.JsonElement serialNumber);
    IWorkbookFunctionsDaysRequestBuilder getDays(final com.google.gson.JsonElement endDate, final com.google.gson.JsonElement startDate);
    IWorkbookFunctionsDays360RequestBuilder getDays360(final com.google.gson.JsonElement startDate, final com.google.gson.JsonElement endDate, final com.google.gson.JsonElement method);
    IWorkbookFunctionsDbRequestBuilder getDb(final com.google.gson.JsonElement cost, final com.google.gson.JsonElement salvage, final com.google.gson.JsonElement life, final com.google.gson.JsonElement period, final com.google.gson.JsonElement month);
    IWorkbookFunctionsDbcsRequestBuilder getDbcs(final com.google.gson.JsonElement text);
    IWorkbookFunctionsDdbRequestBuilder getDdb(final com.google.gson.JsonElement cost, final com.google.gson.JsonElement salvage, final com.google.gson.JsonElement life, final com.google.gson.JsonElement period, final com.google.gson.JsonElement factor);
    IWorkbookFunctionsDec2BinRequestBuilder getDec2Bin(final com.google.gson.JsonElement number, final com.google.gson.JsonElement places);
    IWorkbookFunctionsDec2HexRequestBuilder getDec2Hex(final com.google.gson.JsonElement number, final com.google.gson.JsonElement places);
    IWorkbookFunctionsDec2OctRequestBuilder getDec2Oct(final com.google.gson.JsonElement number, final com.google.gson.JsonElement places);
    IWorkbookFunctionsDecimalRequestBuilder getDecimal(final com.google.gson.JsonElement number, final com.google.gson.JsonElement radix);
    IWorkbookFunctionsDegreesRequestBuilder getDegrees(final com.google.gson.JsonElement angle);
    IWorkbookFunctionsDeltaRequestBuilder getDelta(final com.google.gson.JsonElement number1, final com.google.gson.JsonElement number2);
    IWorkbookFunctionsDevSqRequestBuilder getDevSq(final com.google.gson.JsonElement values);
    IWorkbookFunctionsDiscRequestBuilder getDisc(final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement maturity, final com.google.gson.JsonElement pr, final com.google.gson.JsonElement redemption, final com.google.gson.JsonElement basis);
    IWorkbookFunctionsDollarRequestBuilder getDollar(final com.google.gson.JsonElement number, final com.google.gson.JsonElement decimals);
    IWorkbookFunctionsDollarDeRequestBuilder getDollarDe(final com.google.gson.JsonElement fractionalDollar, final com.google.gson.JsonElement fraction);
    IWorkbookFunctionsDollarFrRequestBuilder getDollarFr(final com.google.gson.JsonElement decimalDollar, final com.google.gson.JsonElement fraction);
    IWorkbookFunctionsDurationRequestBuilder getDuration(final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement maturity, final com.google.gson.JsonElement coupon, final com.google.gson.JsonElement yld, final com.google.gson.JsonElement frequency, final com.google.gson.JsonElement basis);
    IWorkbookFunctionsEcma_CeilingRequestBuilder getEcma_Ceiling(final com.google.gson.JsonElement number, final com.google.gson.JsonElement significance);
    IWorkbookFunctionsEdateRequestBuilder getEdate(final com.google.gson.JsonElement startDate, final com.google.gson.JsonElement months);
    IWorkbookFunctionsEffectRequestBuilder getEffect(final com.google.gson.JsonElement nominalRate, final com.google.gson.JsonElement npery);
    IWorkbookFunctionsEoMonthRequestBuilder getEoMonth(final com.google.gson.JsonElement startDate, final com.google.gson.JsonElement months);
    IWorkbookFunctionsErfRequestBuilder getErf(final com.google.gson.JsonElement lowerLimit, final com.google.gson.JsonElement upperLimit);
    IWorkbookFunctionsErfCRequestBuilder getErfC(final com.google.gson.JsonElement x);
    IWorkbookFunctionsErfC_PreciseRequestBuilder getErfC_Precise(final com.google.gson.JsonElement x);
    IWorkbookFunctionsErf_PreciseRequestBuilder getErf_Precise(final com.google.gson.JsonElement x);
    IWorkbookFunctionsError_TypeRequestBuilder getError_Type(final com.google.gson.JsonElement errorVal);
    IWorkbookFunctionsEvenRequestBuilder getEven(final com.google.gson.JsonElement number);
    IWorkbookFunctionsExactRequestBuilder getExact(final com.google.gson.JsonElement text1, final com.google.gson.JsonElement text2);
    IWorkbookFunctionsExpRequestBuilder getExp(final com.google.gson.JsonElement number);
    IWorkbookFunctionsExpon_DistRequestBuilder getExpon_Dist(final com.google.gson.JsonElement x, final com.google.gson.JsonElement lambda, final com.google.gson.JsonElement cumulative);
    IWorkbookFunctionsFvscheduleRequestBuilder getFvschedule(final com.google.gson.JsonElement principal, final com.google.gson.JsonElement schedule);
    IWorkbookFunctionsF_DistRequestBuilder getF_Dist(final com.google.gson.JsonElement x, final com.google.gson.JsonElement degFreedom1, final com.google.gson.JsonElement degFreedom2, final com.google.gson.JsonElement cumulative);
    IWorkbookFunctionsF_Dist_RTRequestBuilder getF_Dist_RT(final com.google.gson.JsonElement x, final com.google.gson.JsonElement degFreedom1, final com.google.gson.JsonElement degFreedom2);
    IWorkbookFunctionsF_InvRequestBuilder getF_Inv(final com.google.gson.JsonElement probability, final com.google.gson.JsonElement degFreedom1, final com.google.gson.JsonElement degFreedom2);
    IWorkbookFunctionsF_Inv_RTRequestBuilder getF_Inv_RT(final com.google.gson.JsonElement probability, final com.google.gson.JsonElement degFreedom1, final com.google.gson.JsonElement degFreedom2);
    IWorkbookFunctionsFactRequestBuilder getFact(final com.google.gson.JsonElement number);
    IWorkbookFunctionsFactDoubleRequestBuilder getFactDouble(final com.google.gson.JsonElement number);
    IWorkbookFunctionsFalseRequestBuilder getFalse();
    IWorkbookFunctionsFindRequestBuilder getFind(final com.google.gson.JsonElement findText, final com.google.gson.JsonElement withinText, final com.google.gson.JsonElement startNum);
    IWorkbookFunctionsFindBRequestBuilder getFindB(final com.google.gson.JsonElement findText, final com.google.gson.JsonElement withinText, final com.google.gson.JsonElement startNum);
    IWorkbookFunctionsFisherRequestBuilder getFisher(final com.google.gson.JsonElement x);
    IWorkbookFunctionsFisherInvRequestBuilder getFisherInv(final com.google.gson.JsonElement y);
    IWorkbookFunctionsFixedRequestBuilder getFixed(final com.google.gson.JsonElement number, final com.google.gson.JsonElement decimals, final com.google.gson.JsonElement noCommas);
    IWorkbookFunctionsFloor_MathRequestBuilder getFloor_Math(final com.google.gson.JsonElement number, final com.google.gson.JsonElement significance, final com.google.gson.JsonElement mode);
    IWorkbookFunctionsFloor_PreciseRequestBuilder getFloor_Precise(final com.google.gson.JsonElement number, final com.google.gson.JsonElement significance);
    IWorkbookFunctionsFvRequestBuilder getFv(final com.google.gson.JsonElement rate, final com.google.gson.JsonElement nper, final com.google.gson.JsonElement pmt, final com.google.gson.JsonElement pv, final com.google.gson.JsonElement type);
    IWorkbookFunctionsGammaRequestBuilder getGamma(final com.google.gson.JsonElement x);
    IWorkbookFunctionsGammaLnRequestBuilder getGammaLn(final com.google.gson.JsonElement x);
    IWorkbookFunctionsGammaLn_PreciseRequestBuilder getGammaLn_Precise(final com.google.gson.JsonElement x);
    IWorkbookFunctionsGamma_DistRequestBuilder getGamma_Dist(final com.google.gson.JsonElement x, final com.google.gson.JsonElement alpha, final com.google.gson.JsonElement beta, final com.google.gson.JsonElement cumulative);
    IWorkbookFunctionsGamma_InvRequestBuilder getGamma_Inv(final com.google.gson.JsonElement probability, final com.google.gson.JsonElement alpha, final com.google.gson.JsonElement beta);
    IWorkbookFunctionsGaussRequestBuilder getGauss(final com.google.gson.JsonElement x);
    IWorkbookFunctionsGcdRequestBuilder getGcd(final com.google.gson.JsonElement values);
    IWorkbookFunctionsGeStepRequestBuilder getGeStep(final com.google.gson.JsonElement number, final com.google.gson.JsonElement step);
    IWorkbookFunctionsGeoMeanRequestBuilder getGeoMean(final com.google.gson.JsonElement values);
    IWorkbookFunctionsHlookupRequestBuilder getHlookup(final com.google.gson.JsonElement lookupValue, final com.google.gson.JsonElement tableArray, final com.google.gson.JsonElement rowIndexNum, final com.google.gson.JsonElement rangeLookup);
    IWorkbookFunctionsHarMeanRequestBuilder getHarMean(final com.google.gson.JsonElement values);
    IWorkbookFunctionsHex2BinRequestBuilder getHex2Bin(final com.google.gson.JsonElement number, final com.google.gson.JsonElement places);
    IWorkbookFunctionsHex2DecRequestBuilder getHex2Dec(final com.google.gson.JsonElement number);
    IWorkbookFunctionsHex2OctRequestBuilder getHex2Oct(final com.google.gson.JsonElement number, final com.google.gson.JsonElement places);
    IWorkbookFunctionsHourRequestBuilder getHour(final com.google.gson.JsonElement serialNumber);
    IWorkbookFunctionsHypGeom_DistRequestBuilder getHypGeom_Dist(final com.google.gson.JsonElement sampleS, final com.google.gson.JsonElement numberSample, final com.google.gson.JsonElement populationS, final com.google.gson.JsonElement numberPop, final com.google.gson.JsonElement cumulative);
    IWorkbookFunctionsHyperlinkRequestBuilder getHyperlink(final com.google.gson.JsonElement linkLocation, final com.google.gson.JsonElement friendlyName);
    IWorkbookFunctionsIso_CeilingRequestBuilder getIso_Ceiling(final com.google.gson.JsonElement number, final com.google.gson.JsonElement significance);
    IWorkbookFunctionsIfRequestBuilder getIf(final com.google.gson.JsonElement logicalTest, final com.google.gson.JsonElement valueIfTrue, final com.google.gson.JsonElement valueIfFalse);
    IWorkbookFunctionsImAbsRequestBuilder getImAbs(final com.google.gson.JsonElement inumber);
    IWorkbookFunctionsImArgumentRequestBuilder getImArgument(final com.google.gson.JsonElement inumber);
    IWorkbookFunctionsImConjugateRequestBuilder getImConjugate(final com.google.gson.JsonElement inumber);
    IWorkbookFunctionsImCosRequestBuilder getImCos(final com.google.gson.JsonElement inumber);
    IWorkbookFunctionsImCoshRequestBuilder getImCosh(final com.google.gson.JsonElement inumber);
    IWorkbookFunctionsImCotRequestBuilder getImCot(final com.google.gson.JsonElement inumber);
    IWorkbookFunctionsImCscRequestBuilder getImCsc(final com.google.gson.JsonElement inumber);
    IWorkbookFunctionsImCschRequestBuilder getImCsch(final com.google.gson.JsonElement inumber);
    IWorkbookFunctionsImDivRequestBuilder getImDiv(final com.google.gson.JsonElement inumber1, final com.google.gson.JsonElement inumber2);
    IWorkbookFunctionsImExpRequestBuilder getImExp(final com.google.gson.JsonElement inumber);
    IWorkbookFunctionsImLnRequestBuilder getImLn(final com.google.gson.JsonElement inumber);
    IWorkbookFunctionsImLog10RequestBuilder getImLog10(final com.google.gson.JsonElement inumber);
    IWorkbookFunctionsImLog2RequestBuilder getImLog2(final com.google.gson.JsonElement inumber);
    IWorkbookFunctionsImPowerRequestBuilder getImPower(final com.google.gson.JsonElement inumber, final com.google.gson.JsonElement number);
    IWorkbookFunctionsImProductRequestBuilder getImProduct(final com.google.gson.JsonElement values);
    IWorkbookFunctionsImRealRequestBuilder getImReal(final com.google.gson.JsonElement inumber);
    IWorkbookFunctionsImSecRequestBuilder getImSec(final com.google.gson.JsonElement inumber);
    IWorkbookFunctionsImSechRequestBuilder getImSech(final com.google.gson.JsonElement inumber);
    IWorkbookFunctionsImSinRequestBuilder getImSin(final com.google.gson.JsonElement inumber);
    IWorkbookFunctionsImSinhRequestBuilder getImSinh(final com.google.gson.JsonElement inumber);
    IWorkbookFunctionsImSqrtRequestBuilder getImSqrt(final com.google.gson.JsonElement inumber);
    IWorkbookFunctionsImSubRequestBuilder getImSub(final com.google.gson.JsonElement inumber1, final com.google.gson.JsonElement inumber2);
    IWorkbookFunctionsImSumRequestBuilder getImSum(final com.google.gson.JsonElement values);
    IWorkbookFunctionsImTanRequestBuilder getImTan(final com.google.gson.JsonElement inumber);
    IWorkbookFunctionsImaginaryRequestBuilder getImaginary(final com.google.gson.JsonElement inumber);
    IWorkbookFunctionsIntRequestBuilder getInt(final com.google.gson.JsonElement number);
    IWorkbookFunctionsIntRateRequestBuilder getIntRate(final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement maturity, final com.google.gson.JsonElement investment, final com.google.gson.JsonElement redemption, final com.google.gson.JsonElement basis);
    IWorkbookFunctionsIpmtRequestBuilder getIpmt(final com.google.gson.JsonElement rate, final com.google.gson.JsonElement per, final com.google.gson.JsonElement nper, final com.google.gson.JsonElement pv, final com.google.gson.JsonElement fv, final com.google.gson.JsonElement type);
    IWorkbookFunctionsIrrRequestBuilder getIrr(final com.google.gson.JsonElement values, final com.google.gson.JsonElement guess);
    IWorkbookFunctionsIsErrRequestBuilder getIsErr(final com.google.gson.JsonElement value);
    IWorkbookFunctionsIsErrorRequestBuilder getIsError(final com.google.gson.JsonElement value);
    IWorkbookFunctionsIsEvenRequestBuilder getIsEven(final com.google.gson.JsonElement number);
    IWorkbookFunctionsIsFormulaRequestBuilder getIsFormula(final com.google.gson.JsonElement reference);
    IWorkbookFunctionsIsLogicalRequestBuilder getIsLogical(final com.google.gson.JsonElement value);
    IWorkbookFunctionsIsNARequestBuilder getIsNA(final com.google.gson.JsonElement value);
    IWorkbookFunctionsIsNonTextRequestBuilder getIsNonText(final com.google.gson.JsonElement value);
    IWorkbookFunctionsIsNumberRequestBuilder getIsNumber(final com.google.gson.JsonElement value);
    IWorkbookFunctionsIsOddRequestBuilder getIsOdd(final com.google.gson.JsonElement number);
    IWorkbookFunctionsIsTextRequestBuilder getIsText(final com.google.gson.JsonElement value);
    IWorkbookFunctionsIsoWeekNumRequestBuilder getIsoWeekNum(final com.google.gson.JsonElement date);
    IWorkbookFunctionsIspmtRequestBuilder getIspmt(final com.google.gson.JsonElement rate, final com.google.gson.JsonElement per, final com.google.gson.JsonElement nper, final com.google.gson.JsonElement pv);
    IWorkbookFunctionsIsrefRequestBuilder getIsref(final com.google.gson.JsonElement value);
    IWorkbookFunctionsKurtRequestBuilder getKurt(final com.google.gson.JsonElement values);
    IWorkbookFunctionsLargeRequestBuilder getLarge(final com.google.gson.JsonElement array, final com.google.gson.JsonElement k);
    IWorkbookFunctionsLcmRequestBuilder getLcm(final com.google.gson.JsonElement values);
    IWorkbookFunctionsLeftRequestBuilder getLeft(final com.google.gson.JsonElement text, final com.google.gson.JsonElement numChars);
    IWorkbookFunctionsLeftbRequestBuilder getLeftb(final com.google.gson.JsonElement text, final com.google.gson.JsonElement numBytes);
    IWorkbookFunctionsLenRequestBuilder getLen(final com.google.gson.JsonElement text);
    IWorkbookFunctionsLenbRequestBuilder getLenb(final com.google.gson.JsonElement text);
    IWorkbookFunctionsLnRequestBuilder getLn(final com.google.gson.JsonElement number);
    IWorkbookFunctionsLogRequestBuilder getLog(final com.google.gson.JsonElement number, final com.google.gson.JsonElement base);
    IWorkbookFunctionsLog10RequestBuilder getLog10(final com.google.gson.JsonElement number);
    IWorkbookFunctionsLogNorm_DistRequestBuilder getLogNorm_Dist(final com.google.gson.JsonElement x, final com.google.gson.JsonElement mean, final com.google.gson.JsonElement standardDev, final com.google.gson.JsonElement cumulative);
    IWorkbookFunctionsLogNorm_InvRequestBuilder getLogNorm_Inv(final com.google.gson.JsonElement probability, final com.google.gson.JsonElement mean, final com.google.gson.JsonElement standardDev);
    IWorkbookFunctionsLookupRequestBuilder getLookup(final com.google.gson.JsonElement lookupValue, final com.google.gson.JsonElement lookupVector, final com.google.gson.JsonElement resultVector);
    IWorkbookFunctionsLowerRequestBuilder getLower(final com.google.gson.JsonElement text);
    IWorkbookFunctionsMdurationRequestBuilder getMduration(final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement maturity, final com.google.gson.JsonElement coupon, final com.google.gson.JsonElement yld, final com.google.gson.JsonElement frequency, final com.google.gson.JsonElement basis);
    IWorkbookFunctionsMirrRequestBuilder getMirr(final com.google.gson.JsonElement values, final com.google.gson.JsonElement financeRate, final com.google.gson.JsonElement reinvestRate);
    IWorkbookFunctionsMroundRequestBuilder getMround(final com.google.gson.JsonElement number, final com.google.gson.JsonElement multiple);
    IWorkbookFunctionsMatchRequestBuilder getMatch(final com.google.gson.JsonElement lookupValue, final com.google.gson.JsonElement lookupArray, final com.google.gson.JsonElement matchType);
    IWorkbookFunctionsMaxRequestBuilder getMax(final com.google.gson.JsonElement values);
    IWorkbookFunctionsMaxARequestBuilder getMaxA(final com.google.gson.JsonElement values);
    IWorkbookFunctionsMedianRequestBuilder getMedian(final com.google.gson.JsonElement values);
    IWorkbookFunctionsMidRequestBuilder getMid(final com.google.gson.JsonElement text, final com.google.gson.JsonElement startNum, final com.google.gson.JsonElement numChars);
    IWorkbookFunctionsMidbRequestBuilder getMidb(final com.google.gson.JsonElement text, final com.google.gson.JsonElement startNum, final com.google.gson.JsonElement numBytes);
    IWorkbookFunctionsMinRequestBuilder getMin(final com.google.gson.JsonElement values);
    IWorkbookFunctionsMinARequestBuilder getMinA(final com.google.gson.JsonElement values);
    IWorkbookFunctionsMinuteRequestBuilder getMinute(final com.google.gson.JsonElement serialNumber);
    IWorkbookFunctionsModRequestBuilder getMod(final com.google.gson.JsonElement number, final com.google.gson.JsonElement divisor);
    IWorkbookFunctionsMonthRequestBuilder getMonth(final com.google.gson.JsonElement serialNumber);
    IWorkbookFunctionsMultiNomialRequestBuilder getMultiNomial(final com.google.gson.JsonElement values);
    IWorkbookFunctionsNRequestBuilder getN(final com.google.gson.JsonElement value);
    IWorkbookFunctionsNperRequestBuilder getNper(final com.google.gson.JsonElement rate, final com.google.gson.JsonElement pmt, final com.google.gson.JsonElement pv, final com.google.gson.JsonElement fv, final com.google.gson.JsonElement type);
    IWorkbookFunctionsNaRequestBuilder getNa();
    IWorkbookFunctionsNegBinom_DistRequestBuilder getNegBinom_Dist(final com.google.gson.JsonElement numberF, final com.google.gson.JsonElement numberS, final com.google.gson.JsonElement probabilityS, final com.google.gson.JsonElement cumulative);
    IWorkbookFunctionsNetworkDaysRequestBuilder getNetworkDays(final com.google.gson.JsonElement startDate, final com.google.gson.JsonElement endDate, final com.google.gson.JsonElement holidays);
    IWorkbookFunctionsNetworkDays_IntlRequestBuilder getNetworkDays_Intl(final com.google.gson.JsonElement startDate, final com.google.gson.JsonElement endDate, final com.google.gson.JsonElement weekend, final com.google.gson.JsonElement holidays);
    IWorkbookFunctionsNominalRequestBuilder getNominal(final com.google.gson.JsonElement effectRate, final com.google.gson.JsonElement npery);
    IWorkbookFunctionsNorm_DistRequestBuilder getNorm_Dist(final com.google.gson.JsonElement x, final com.google.gson.JsonElement mean, final com.google.gson.JsonElement standardDev, final com.google.gson.JsonElement cumulative);
    IWorkbookFunctionsNorm_InvRequestBuilder getNorm_Inv(final com.google.gson.JsonElement probability, final com.google.gson.JsonElement mean, final com.google.gson.JsonElement standardDev);
    IWorkbookFunctionsNorm_S_DistRequestBuilder getNorm_S_Dist(final com.google.gson.JsonElement z, final com.google.gson.JsonElement cumulative);
    IWorkbookFunctionsNorm_S_InvRequestBuilder getNorm_S_Inv(final com.google.gson.JsonElement probability);
    IWorkbookFunctionsNotRequestBuilder getNot(final com.google.gson.JsonElement logical);
    IWorkbookFunctionsNowRequestBuilder getNow();
    IWorkbookFunctionsNpvRequestBuilder getNpv(final com.google.gson.JsonElement rate, final com.google.gson.JsonElement values);
    IWorkbookFunctionsNumberValueRequestBuilder getNumberValue(final com.google.gson.JsonElement text, final com.google.gson.JsonElement decimalSeparator, final com.google.gson.JsonElement groupSeparator);
    IWorkbookFunctionsOct2BinRequestBuilder getOct2Bin(final com.google.gson.JsonElement number, final com.google.gson.JsonElement places);
    IWorkbookFunctionsOct2DecRequestBuilder getOct2Dec(final com.google.gson.JsonElement number);
    IWorkbookFunctionsOct2HexRequestBuilder getOct2Hex(final com.google.gson.JsonElement number, final com.google.gson.JsonElement places);
    IWorkbookFunctionsOddRequestBuilder getOdd(final com.google.gson.JsonElement number);
    IWorkbookFunctionsOddFPriceRequestBuilder getOddFPrice(final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement maturity, final com.google.gson.JsonElement issue, final com.google.gson.JsonElement firstCoupon, final com.google.gson.JsonElement rate, final com.google.gson.JsonElement yld, final com.google.gson.JsonElement redemption, final com.google.gson.JsonElement frequency, final com.google.gson.JsonElement basis);
    IWorkbookFunctionsOddFYieldRequestBuilder getOddFYield(final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement maturity, final com.google.gson.JsonElement issue, final com.google.gson.JsonElement firstCoupon, final com.google.gson.JsonElement rate, final com.google.gson.JsonElement pr, final com.google.gson.JsonElement redemption, final com.google.gson.JsonElement frequency, final com.google.gson.JsonElement basis);
    IWorkbookFunctionsOddLPriceRequestBuilder getOddLPrice(final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement maturity, final com.google.gson.JsonElement lastInterest, final com.google.gson.JsonElement rate, final com.google.gson.JsonElement yld, final com.google.gson.JsonElement redemption, final com.google.gson.JsonElement frequency, final com.google.gson.JsonElement basis);
    IWorkbookFunctionsOddLYieldRequestBuilder getOddLYield(final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement maturity, final com.google.gson.JsonElement lastInterest, final com.google.gson.JsonElement rate, final com.google.gson.JsonElement pr, final com.google.gson.JsonElement redemption, final com.google.gson.JsonElement frequency, final com.google.gson.JsonElement basis);
    IWorkbookFunctionsOrRequestBuilder getOr(final com.google.gson.JsonElement values);
    IWorkbookFunctionsPdurationRequestBuilder getPduration(final com.google.gson.JsonElement rate, final com.google.gson.JsonElement pv, final com.google.gson.JsonElement fv);
    IWorkbookFunctionsPercentRank_ExcRequestBuilder getPercentRank_Exc(final com.google.gson.JsonElement array, final com.google.gson.JsonElement x, final com.google.gson.JsonElement significance);
    IWorkbookFunctionsPercentRank_IncRequestBuilder getPercentRank_Inc(final com.google.gson.JsonElement array, final com.google.gson.JsonElement x, final com.google.gson.JsonElement significance);
    IWorkbookFunctionsPercentile_ExcRequestBuilder getPercentile_Exc(final com.google.gson.JsonElement array, final com.google.gson.JsonElement k);
    IWorkbookFunctionsPercentile_IncRequestBuilder getPercentile_Inc(final com.google.gson.JsonElement array, final com.google.gson.JsonElement k);
    IWorkbookFunctionsPermutRequestBuilder getPermut(final com.google.gson.JsonElement number, final com.google.gson.JsonElement numberChosen);
    IWorkbookFunctionsPermutationaRequestBuilder getPermutationa(final com.google.gson.JsonElement number, final com.google.gson.JsonElement numberChosen);
    IWorkbookFunctionsPhiRequestBuilder getPhi(final com.google.gson.JsonElement x);
    IWorkbookFunctionsPiRequestBuilder getPi();
    IWorkbookFunctionsPmtRequestBuilder getPmt(final com.google.gson.JsonElement rate, final com.google.gson.JsonElement nper, final com.google.gson.JsonElement pv, final com.google.gson.JsonElement fv, final com.google.gson.JsonElement type);
    IWorkbookFunctionsPoisson_DistRequestBuilder getPoisson_Dist(final com.google.gson.JsonElement x, final com.google.gson.JsonElement mean, final com.google.gson.JsonElement cumulative);
    IWorkbookFunctionsPowerRequestBuilder getPower(final com.google.gson.JsonElement number, final com.google.gson.JsonElement power);
    IWorkbookFunctionsPpmtRequestBuilder getPpmt(final com.google.gson.JsonElement rate, final com.google.gson.JsonElement per, final com.google.gson.JsonElement nper, final com.google.gson.JsonElement pv, final com.google.gson.JsonElement fv, final com.google.gson.JsonElement type);
    IWorkbookFunctionsPriceRequestBuilder getPrice(final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement maturity, final com.google.gson.JsonElement rate, final com.google.gson.JsonElement yld, final com.google.gson.JsonElement redemption, final com.google.gson.JsonElement frequency, final com.google.gson.JsonElement basis);
    IWorkbookFunctionsPriceDiscRequestBuilder getPriceDisc(final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement maturity, final com.google.gson.JsonElement discount, final com.google.gson.JsonElement redemption, final com.google.gson.JsonElement basis);
    IWorkbookFunctionsPriceMatRequestBuilder getPriceMat(final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement maturity, final com.google.gson.JsonElement issue, final com.google.gson.JsonElement rate, final com.google.gson.JsonElement yld, final com.google.gson.JsonElement basis);
    IWorkbookFunctionsProductRequestBuilder getProduct(final com.google.gson.JsonElement values);
    IWorkbookFunctionsProperRequestBuilder getProper(final com.google.gson.JsonElement text);
    IWorkbookFunctionsPvRequestBuilder getPv(final com.google.gson.JsonElement rate, final com.google.gson.JsonElement nper, final com.google.gson.JsonElement pmt, final com.google.gson.JsonElement fv, final com.google.gson.JsonElement type);
    IWorkbookFunctionsQuartile_ExcRequestBuilder getQuartile_Exc(final com.google.gson.JsonElement array, final com.google.gson.JsonElement quart);
    IWorkbookFunctionsQuartile_IncRequestBuilder getQuartile_Inc(final com.google.gson.JsonElement array, final com.google.gson.JsonElement quart);
    IWorkbookFunctionsQuotientRequestBuilder getQuotient(final com.google.gson.JsonElement numerator, final com.google.gson.JsonElement denominator);
    IWorkbookFunctionsRadiansRequestBuilder getRadians(final com.google.gson.JsonElement angle);
    IWorkbookFunctionsRandRequestBuilder getRand();
    IWorkbookFunctionsRandBetweenRequestBuilder getRandBetween(final com.google.gson.JsonElement bottom, final com.google.gson.JsonElement top);
    IWorkbookFunctionsRank_AvgRequestBuilder getRank_Avg(final com.google.gson.JsonElement number, final com.google.gson.JsonElement ref, final com.google.gson.JsonElement order);
    IWorkbookFunctionsRank_EqRequestBuilder getRank_Eq(final com.google.gson.JsonElement number, final com.google.gson.JsonElement ref, final com.google.gson.JsonElement order);
    IWorkbookFunctionsRateRequestBuilder getRate(final com.google.gson.JsonElement nper, final com.google.gson.JsonElement pmt, final com.google.gson.JsonElement pv, final com.google.gson.JsonElement fv, final com.google.gson.JsonElement type, final com.google.gson.JsonElement guess);
    IWorkbookFunctionsReceivedRequestBuilder getReceived(final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement maturity, final com.google.gson.JsonElement investment, final com.google.gson.JsonElement discount, final com.google.gson.JsonElement basis);
    IWorkbookFunctionsReplaceRequestBuilder getReplace(final com.google.gson.JsonElement oldText, final com.google.gson.JsonElement startNum, final com.google.gson.JsonElement numChars, final com.google.gson.JsonElement newText);
    IWorkbookFunctionsReplaceBRequestBuilder getReplaceB(final com.google.gson.JsonElement oldText, final com.google.gson.JsonElement startNum, final com.google.gson.JsonElement numBytes, final com.google.gson.JsonElement newText);
    IWorkbookFunctionsReptRequestBuilder getRept(final com.google.gson.JsonElement text, final com.google.gson.JsonElement numberTimes);
    IWorkbookFunctionsRightRequestBuilder getRight(final com.google.gson.JsonElement text, final com.google.gson.JsonElement numChars);
    IWorkbookFunctionsRightbRequestBuilder getRightb(final com.google.gson.JsonElement text, final com.google.gson.JsonElement numBytes);
    IWorkbookFunctionsRomanRequestBuilder getRoman(final com.google.gson.JsonElement number, final com.google.gson.JsonElement form);
    IWorkbookFunctionsRoundRequestBuilder getRound(final com.google.gson.JsonElement number, final com.google.gson.JsonElement numDigits);
    IWorkbookFunctionsRoundDownRequestBuilder getRoundDown(final com.google.gson.JsonElement number, final com.google.gson.JsonElement numDigits);
    IWorkbookFunctionsRoundUpRequestBuilder getRoundUp(final com.google.gson.JsonElement number, final com.google.gson.JsonElement numDigits);
    IWorkbookFunctionsRowsRequestBuilder getRows(final com.google.gson.JsonElement array);
    IWorkbookFunctionsRriRequestBuilder getRri(final com.google.gson.JsonElement nper, final com.google.gson.JsonElement pv, final com.google.gson.JsonElement fv);
    IWorkbookFunctionsSecRequestBuilder getSec(final com.google.gson.JsonElement number);
    IWorkbookFunctionsSechRequestBuilder getSech(final com.google.gson.JsonElement number);
    IWorkbookFunctionsSecondRequestBuilder getSecond(final com.google.gson.JsonElement serialNumber);
    IWorkbookFunctionsSeriesSumRequestBuilder getSeriesSum(final com.google.gson.JsonElement x, final com.google.gson.JsonElement n, final com.google.gson.JsonElement m, final com.google.gson.JsonElement coefficients);
    IWorkbookFunctionsSheetRequestBuilder getSheet(final com.google.gson.JsonElement value);
    IWorkbookFunctionsSheetsRequestBuilder getSheets(final com.google.gson.JsonElement reference);
    IWorkbookFunctionsSignRequestBuilder getSign(final com.google.gson.JsonElement number);
    IWorkbookFunctionsSinRequestBuilder getSin(final com.google.gson.JsonElement number);
    IWorkbookFunctionsSinhRequestBuilder getSinh(final com.google.gson.JsonElement number);
    IWorkbookFunctionsSkewRequestBuilder getSkew(final com.google.gson.JsonElement values);
    IWorkbookFunctionsSkew_pRequestBuilder getSkew_p(final com.google.gson.JsonElement values);
    IWorkbookFunctionsSlnRequestBuilder getSln(final com.google.gson.JsonElement cost, final com.google.gson.JsonElement salvage, final com.google.gson.JsonElement life);
    IWorkbookFunctionsSmallRequestBuilder getSmall(final com.google.gson.JsonElement array, final com.google.gson.JsonElement k);
    IWorkbookFunctionsSqrtRequestBuilder getSqrt(final com.google.gson.JsonElement number);
    IWorkbookFunctionsSqrtPiRequestBuilder getSqrtPi(final com.google.gson.JsonElement number);
    IWorkbookFunctionsStDevARequestBuilder getStDevA(final com.google.gson.JsonElement values);
    IWorkbookFunctionsStDevPARequestBuilder getStDevPA(final com.google.gson.JsonElement values);
    IWorkbookFunctionsStDev_PRequestBuilder getStDev_P(final com.google.gson.JsonElement values);
    IWorkbookFunctionsStDev_SRequestBuilder getStDev_S(final com.google.gson.JsonElement values);
    IWorkbookFunctionsStandardizeRequestBuilder getStandardize(final com.google.gson.JsonElement x, final com.google.gson.JsonElement mean, final com.google.gson.JsonElement standardDev);
    IWorkbookFunctionsSubstituteRequestBuilder getSubstitute(final com.google.gson.JsonElement text, final com.google.gson.JsonElement oldText, final com.google.gson.JsonElement newText, final com.google.gson.JsonElement instanceNum);
    IWorkbookFunctionsSubtotalRequestBuilder getSubtotal(final com.google.gson.JsonElement functionNum, final com.google.gson.JsonElement values);
    IWorkbookFunctionsSumRequestBuilder getSum(final com.google.gson.JsonElement values);
    IWorkbookFunctionsSumIfRequestBuilder getSumIf(final com.google.gson.JsonElement range, final com.google.gson.JsonElement criteria, final com.google.gson.JsonElement sumRange);
    IWorkbookFunctionsSumIfsRequestBuilder getSumIfs(final com.google.gson.JsonElement sumRange, final com.google.gson.JsonElement values);
    IWorkbookFunctionsSumSqRequestBuilder getSumSq(final com.google.gson.JsonElement values);
    IWorkbookFunctionsSydRequestBuilder getSyd(final com.google.gson.JsonElement cost, final com.google.gson.JsonElement salvage, final com.google.gson.JsonElement life, final com.google.gson.JsonElement per);
    IWorkbookFunctionsTRequestBuilder getT(final com.google.gson.JsonElement value);
    IWorkbookFunctionsTbillEqRequestBuilder getTbillEq(final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement maturity, final com.google.gson.JsonElement discount);
    IWorkbookFunctionsTbillPriceRequestBuilder getTbillPrice(final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement maturity, final com.google.gson.JsonElement discount);
    IWorkbookFunctionsTbillYieldRequestBuilder getTbillYield(final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement maturity, final com.google.gson.JsonElement pr);
    IWorkbookFunctionsT_DistRequestBuilder getT_Dist(final com.google.gson.JsonElement x, final com.google.gson.JsonElement degFreedom, final com.google.gson.JsonElement cumulative);
    IWorkbookFunctionsT_Dist_2TRequestBuilder getT_Dist_2T(final com.google.gson.JsonElement x, final com.google.gson.JsonElement degFreedom);
    IWorkbookFunctionsT_Dist_RTRequestBuilder getT_Dist_RT(final com.google.gson.JsonElement x, final com.google.gson.JsonElement degFreedom);
    IWorkbookFunctionsT_InvRequestBuilder getT_Inv(final com.google.gson.JsonElement probability, final com.google.gson.JsonElement degFreedom);
    IWorkbookFunctionsT_Inv_2TRequestBuilder getT_Inv_2T(final com.google.gson.JsonElement probability, final com.google.gson.JsonElement degFreedom);
    IWorkbookFunctionsTanRequestBuilder getTan(final com.google.gson.JsonElement number);
    IWorkbookFunctionsTanhRequestBuilder getTanh(final com.google.gson.JsonElement number);
    IWorkbookFunctionsTextRequestBuilder getText(final com.google.gson.JsonElement value, final com.google.gson.JsonElement formatText);
    IWorkbookFunctionsTimeRequestBuilder getTime(final com.google.gson.JsonElement hour, final com.google.gson.JsonElement minute, final com.google.gson.JsonElement second);
    IWorkbookFunctionsTimevalueRequestBuilder getTimevalue(final com.google.gson.JsonElement timeText);
    IWorkbookFunctionsTodayRequestBuilder getToday();
    IWorkbookFunctionsTrimRequestBuilder getTrim(final com.google.gson.JsonElement text);
    IWorkbookFunctionsTrimMeanRequestBuilder getTrimMean(final com.google.gson.JsonElement array, final com.google.gson.JsonElement percent);
    IWorkbookFunctionsTrueRequestBuilder getTrue();
    IWorkbookFunctionsTruncRequestBuilder getTrunc(final com.google.gson.JsonElement number, final com.google.gson.JsonElement numDigits);
    IWorkbookFunctionsTypeRequestBuilder getType(final com.google.gson.JsonElement value);
    IWorkbookFunctionsUsdollarRequestBuilder getUsdollar(final com.google.gson.JsonElement number, final com.google.gson.JsonElement decimals);
    IWorkbookFunctionsUnicharRequestBuilder getUnichar(final com.google.gson.JsonElement number);
    IWorkbookFunctionsUnicodeRequestBuilder getUnicode(final com.google.gson.JsonElement text);
    IWorkbookFunctionsUpperRequestBuilder getUpper(final com.google.gson.JsonElement text);
    IWorkbookFunctionsVlookupRequestBuilder getVlookup(final com.google.gson.JsonElement lookupValue, final com.google.gson.JsonElement tableArray, final com.google.gson.JsonElement colIndexNum, final com.google.gson.JsonElement rangeLookup);
    IWorkbookFunctionsValueRequestBuilder getValue(final com.google.gson.JsonElement text);
    IWorkbookFunctionsVarARequestBuilder getVarA(final com.google.gson.JsonElement values);
    IWorkbookFunctionsVarPARequestBuilder getVarPA(final com.google.gson.JsonElement values);
    IWorkbookFunctionsVar_PRequestBuilder getVar_P(final com.google.gson.JsonElement values);
    IWorkbookFunctionsVar_SRequestBuilder getVar_S(final com.google.gson.JsonElement values);
    IWorkbookFunctionsVdbRequestBuilder getVdb(final com.google.gson.JsonElement cost, final com.google.gson.JsonElement salvage, final com.google.gson.JsonElement life, final com.google.gson.JsonElement startPeriod, final com.google.gson.JsonElement endPeriod, final com.google.gson.JsonElement factor, final com.google.gson.JsonElement noSwitch);
    IWorkbookFunctionsWeekNumRequestBuilder getWeekNum(final com.google.gson.JsonElement serialNumber, final com.google.gson.JsonElement returnType);
    IWorkbookFunctionsWeekdayRequestBuilder getWeekday(final com.google.gson.JsonElement serialNumber, final com.google.gson.JsonElement returnType);
    IWorkbookFunctionsWeibull_DistRequestBuilder getWeibull_Dist(final com.google.gson.JsonElement x, final com.google.gson.JsonElement alpha, final com.google.gson.JsonElement beta, final com.google.gson.JsonElement cumulative);
    IWorkbookFunctionsWorkDayRequestBuilder getWorkDay(final com.google.gson.JsonElement startDate, final com.google.gson.JsonElement days, final com.google.gson.JsonElement holidays);
    IWorkbookFunctionsWorkDay_IntlRequestBuilder getWorkDay_Intl(final com.google.gson.JsonElement startDate, final com.google.gson.JsonElement days, final com.google.gson.JsonElement weekend, final com.google.gson.JsonElement holidays);
    IWorkbookFunctionsXirrRequestBuilder getXirr(final com.google.gson.JsonElement values, final com.google.gson.JsonElement dates, final com.google.gson.JsonElement guess);
    IWorkbookFunctionsXnpvRequestBuilder getXnpv(final com.google.gson.JsonElement rate, final com.google.gson.JsonElement values, final com.google.gson.JsonElement dates);
    IWorkbookFunctionsXorRequestBuilder getXor(final com.google.gson.JsonElement values);
    IWorkbookFunctionsYearRequestBuilder getYear(final com.google.gson.JsonElement serialNumber);
    IWorkbookFunctionsYearFracRequestBuilder getYearFrac(final com.google.gson.JsonElement startDate, final com.google.gson.JsonElement endDate, final com.google.gson.JsonElement basis);
    IWorkbookFunctionsYieldRequestBuilder getYield(final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement maturity, final com.google.gson.JsonElement rate, final com.google.gson.JsonElement pr, final com.google.gson.JsonElement redemption, final com.google.gson.JsonElement frequency, final com.google.gson.JsonElement basis);
    IWorkbookFunctionsYieldDiscRequestBuilder getYieldDisc(final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement maturity, final com.google.gson.JsonElement pr, final com.google.gson.JsonElement redemption, final com.google.gson.JsonElement basis);
    IWorkbookFunctionsYieldMatRequestBuilder getYieldMat(final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement maturity, final com.google.gson.JsonElement issue, final com.google.gson.JsonElement rate, final com.google.gson.JsonElement pr, final com.google.gson.JsonElement basis);
    IWorkbookFunctionsZ_TestRequestBuilder getZ_Test(final com.google.gson.JsonElement array, final com.google.gson.JsonElement x, final com.google.gson.JsonElement sigma);

}
