// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Workbook Chart Area Format Request.
 */
public interface IBaseWorkbookChartAreaFormatRequest extends IHttpRequest {

    /**
     * Gets the WorkbookChartAreaFormat from the service
     * @param callback The callback to be called after success or failure.
     */
    void get(final ICallback<WorkbookChartAreaFormat> callback);

    /**
     * Gets the WorkbookChartAreaFormat from the service
     * @return The WorkbookChartAreaFormat from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    WorkbookChartAreaFormat get() throws ClientException;

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    void delete(final ICallback<Void> callback);

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this WorkbookChartAreaFormat with a source
     * @param sourceWorkbookChartAreaFormat The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    void patch(final WorkbookChartAreaFormat sourceWorkbookChartAreaFormat, final ICallback<WorkbookChartAreaFormat> callback);

    /**
     * Patches this WorkbookChartAreaFormat with a source
     * @param sourceWorkbookChartAreaFormat The source object with updates
     * @return The updated WorkbookChartAreaFormat
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    WorkbookChartAreaFormat patch(final WorkbookChartAreaFormat sourceWorkbookChartAreaFormat) throws ClientException;

    /**
     * Posts a WorkbookChartAreaFormat with a new object
     * @param newWorkbookChartAreaFormat The new object to create
     * @param callback The callback to be called after success or failure.
     */
    void post(final WorkbookChartAreaFormat newWorkbookChartAreaFormat, final ICallback<WorkbookChartAreaFormat> callback);

    /**
     * Posts a WorkbookChartAreaFormat with a new object
     * @param newWorkbookChartAreaFormat The new object to create
     * @return The created WorkbookChartAreaFormat
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    WorkbookChartAreaFormat post(final WorkbookChartAreaFormat newWorkbookChartAreaFormat) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBaseWorkbookChartAreaFormatRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBaseWorkbookChartAreaFormatRequest expand(final String value);

}

