// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Planner User Request.
 */
public interface IBasePlannerUserRequest extends IHttpRequest {

    /**
     * Gets the PlannerUser from the service
     * @param callback The callback to be called after success or failure.
     */
    void get(final ICallback<PlannerUser> callback);

    /**
     * Gets the PlannerUser from the service
     * @return The PlannerUser from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    PlannerUser get() throws ClientException;

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    void delete(final ICallback<Void> callback);

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this PlannerUser with a source
     * @param sourcePlannerUser The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    void patch(final PlannerUser sourcePlannerUser, final ICallback<PlannerUser> callback);

    /**
     * Patches this PlannerUser with a source
     * @param sourcePlannerUser The source object with updates
     * @return The updated PlannerUser
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    PlannerUser patch(final PlannerUser sourcePlannerUser) throws ClientException;

    /**
     * Posts a PlannerUser with a new object
     * @param newPlannerUser The new object to create
     * @param callback The callback to be called after success or failure.
     */
    void post(final PlannerUser newPlannerUser, final ICallback<PlannerUser> callback);

    /**
     * Posts a PlannerUser with a new object
     * @param newPlannerUser The new object to create
     * @return The created PlannerUser
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    PlannerUser post(final PlannerUser newPlannerUser) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBasePlannerUserRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBasePlannerUserRequest expand(final String value);

}

