// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Extension Request.
 */
public interface IBaseExtensionRequest extends IHttpRequest {

    /**
     * Gets the Extension from the service
     * @param callback The callback to be called after success or failure.
     */
    void getExtension(final ICallback<Extension> callback);

    /**
     * Gets the Extension from the service
     * @return The Extension from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    Extension getExtension() throws ClientException;

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    void delete(final ICallback<Void> callback);

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this Extension with a source
     * @param sourceExtension The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    void patch(final Extension sourceExtension, final ICallback<Extension> callback);

    /**
     * Patches this Extension with a source
     * @param sourceExtension The source object with updates
     * @return The updated Extension
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    Extension patch(final Extension sourceExtension) throws ClientException;

    /**
     * Posts a Extension with a new object
     * @param newExtension The new object to create
     * @param callback The callback to be called after success or failure.
     */
    void post(final Extension newExtension, final ICallback<Extension> callback);

    /**
     * Posts a Extension with a new object
     * @param newExtension The new object to create
     * @return The created Extension
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    Extension post(final Extension newExtension) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBaseExtensionRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBaseExtensionRequest expand(final String value);

}

