// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Education Root Request.
 */
public interface IBaseEducationRootRequest extends IHttpRequest {

    /**
     * Gets the EducationRoot from the service
     * @param callback The callback to be called after success or failure.
     */
    void get(final ICallback<EducationRoot> callback);

    /**
     * Gets the EducationRoot from the service
     * @return The EducationRoot from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    EducationRoot get() throws ClientException;

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    void delete(final ICallback<Void> callback);

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this EducationRoot with a source
     * @param sourceEducationRoot The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    void patch(final EducationRoot sourceEducationRoot, final ICallback<EducationRoot> callback);

    /**
     * Patches this EducationRoot with a source
     * @param sourceEducationRoot The source object with updates
     * @return The updated EducationRoot
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    EducationRoot patch(final EducationRoot sourceEducationRoot) throws ClientException;

    /**
     * Posts a EducationRoot with a new object
     * @param newEducationRoot The new object to create
     * @param callback The callback to be called after success or failure.
     */
    void post(final EducationRoot newEducationRoot, final ICallback<EducationRoot> callback);

    /**
     * Posts a EducationRoot with a new object
     * @param newEducationRoot The new object to create
     * @return The created EducationRoot
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    EducationRoot post(final EducationRoot newEducationRoot) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBaseEducationRootRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBaseEducationRootRequest expand(final String value);

}

